/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.registry.specialeffects;

import java.util.Objects;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.registry.SpecialEffectsRegistry;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class SpecialEffect {
    public static final ResourceKey<Registry<SpecialEffect>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)SlashBlade.prefix("special_effect"));
    private final int requestLevel;
    private final boolean isCopiable;
    private final boolean isRemovable;
    private String descriptionId;

    public SpecialEffect(int requestLevel) {
        this(requestLevel, false, false);
    }

    public SpecialEffect(int requestLevel, boolean isCopiable, boolean isRemovable) {
        this.requestLevel = requestLevel;
        this.isCopiable = isCopiable;
        this.isRemovable = isRemovable;
    }

    public int getRequestLevel() {
        return this.requestLevel;
    }

    public boolean isCopiable() {
        return this.isCopiable;
    }

    public boolean isRemovable() {
        return this.isRemovable;
    }

    public static boolean isEffective(SpecialEffect se, int level) {
        return se.requestLevel <= level;
    }

    public static boolean isEffective(ResourceLocation id, int level) {
        return Objects.requireNonNull((SpecialEffect)SpecialEffectsRegistry.REGISTRY.get().getValue(id)).getRequestLevel() <= level;
    }

    public static Component getDescription(ResourceLocation id) {
        return Objects.requireNonNull((SpecialEffect)SpecialEffectsRegistry.REGISTRY.get().getValue(id)).getDescription();
    }

    public static int getRequestLevel(ResourceLocation id) {
        return Objects.requireNonNull((SpecialEffect)SpecialEffectsRegistry.REGISTRY.get().getValue(id)).getRequestLevel();
    }

    public Component getDescription() {
        return Component.m_237115_((String)this.getDescriptionId());
    }

    public String toString() {
        return Objects.requireNonNull(SpecialEffectsRegistry.REGISTRY.get().getKey((Object)this)).toString();
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"se", (ResourceLocation)SpecialEffectsRegistry.REGISTRY.get().getKey((Object)this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }
}

