/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nymmd;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Vector;
import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.MmdMotionPlayer;
import jp.nyatla.nymmd.MmdPmdModel_BasicClass;
import jp.nyatla.nymmd.MmdVmdMotion_BasicClass;
import jp.nyatla.nymmd.types.MmdMatrix;
import jp.nyatla.nymmd.types.MmdTexUV;
import jp.nyatla.nymmd.types.MmdVector3;
import jp.nyatla.nymmd.types.PmdMaterial;
import jp.nyatla.nymmd.types.PmdSkinInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MmdMotionPlayerGL2
extends MmdMotionPlayer {
    private final MmdMatrix __tmp_matrix = new MmdMatrix();
    private Material[] _materials;
    private float[] _fbuf;
    private MmdTexUV[] _tex_array;

    @Override
    public void setPmd(MmdPmdModel_BasicClass i_pmd_model) throws MmdException {
        super.setPmd(i_pmd_model);
        int number_of_vertex = i_pmd_model.getNumberOfVertex();
        this._fbuf = new float[number_of_vertex * 3 * 2];
        MmdPmdModel_BasicClass.IResourceProvider tp = i_pmd_model.getResourceProvider();
        PmdMaterial[] m = i_pmd_model.getMaterials();
        Vector<Material> materials = new Vector<Material>();
        for (int i = 0; i < m.length; ++i) {
            Material new_material = new Material();
            new_material.unknown = m[i].unknown;
            float[] color = new float[12];
            m[i].col4Diffuse.getValue(color, 0);
            m[i].col4Ambient.getValue(color, 4);
            m[i].col4Specular.getValue(color, 8);
            new_material.color = color;
            new_material.fShininess = m[i].fShininess;
            new_material.texture_id = m[i].texture_name != null && !m[i].texture_name.isEmpty() ? tp.getTextureStream(m[i].texture_name) : null;
            new_material.indices = m[i].indices;
            new_material.ulNumIndices = m[i].indices.length;
            materials.add(new_material);
        }
        this._materials = materials.toArray(new Material[materials.size()]);
        this._tex_array = this._ref_pmd_model.getUvArray();
    }

    @Override
    public void setVmd(MmdVmdMotion_BasicClass i_vmd_model) throws MmdException {
        super.setVmd(i_vmd_model);
    }

    @Override
    protected void onUpdateSkinningMatrix(MmdMatrix[] i_skinning_mat) throws MmdException {
        MmdVector3[] org_pos_array = this._ref_pmd_model.getPositionArray();
        MmdVector3[] org_normal_array = this._ref_pmd_model.getNormatArray();
        PmdSkinInfo[] org_skin_info = this._ref_pmd_model.getSkinInfoArray();
        int number_of_vertex = this._ref_pmd_model.getNumberOfVertex();
        float[] ft = this._fbuf;
        int p1 = 0;
        int p2 = number_of_vertex * 3;
        for (int i = 0; i < this._ref_pmd_model.getNumberOfVertex(); ++i) {
            MmdMatrix mat;
            PmdSkinInfo info_ptr = org_skin_info[i];
            if (info_ptr.fWeight == 0.0f) {
                mat = i_skinning_mat[info_ptr.unBoneNo_1];
            } else if (info_ptr.fWeight >= 0.9999f) {
                mat = i_skinning_mat[info_ptr.unBoneNo_0];
            } else {
                MmdMatrix mat0 = i_skinning_mat[info_ptr.unBoneNo_0];
                MmdMatrix mat1 = i_skinning_mat[info_ptr.unBoneNo_1];
                mat = this.__tmp_matrix;
                mat.MatrixLerp(mat0, mat1, info_ptr.fWeight);
            }
            MmdVector3 vp = org_pos_array[i];
            ft[p1++] = (float)((double)vp.x * mat.m00 + (double)vp.y * mat.m10 + (double)vp.z * mat.m20 + mat.m30);
            ft[p1++] = (float)((double)vp.x * mat.m01 + (double)vp.y * mat.m11 + (double)vp.z * mat.m21 + mat.m31);
            ft[p1++] = (float)((double)vp.x * mat.m02 + (double)vp.y * mat.m12 + (double)vp.z * mat.m22 + mat.m32);
            vp = org_normal_array[i];
            ft[p2++] = (float)((double)vp.x * mat.m00 + (double)vp.y * mat.m10 + (double)vp.z * mat.m20);
            ft[p2++] = (float)((double)vp.x * mat.m01 + (double)vp.y * mat.m11 + (double)vp.z * mat.m21);
            ft[p2++] = (float)((double)vp.x * mat.m02 + (double)vp.y * mat.m12 + (double)vp.z * mat.m22);
        }
    }

    public void render() {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushClientAttrib((int)-1);
        GL11.glEnable((int)2884);
        GL11.glCullFace((int)1028);
        GL11.glEnable((int)2977);
        GL11.glShadeModel((int)7425);
        BufferBuilder wr = Tesselator.m_85913_().m_85915_();
        int number_of_vertex = this._ref_pmd_model.getNumberOfVertex();
        for (int i = this._materials.length - 1; i >= 0; --i) {
            wr.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85822_);
            Material mt_ptr = this._materials[i];
            for (short pos : mt_ptr.indices) {
                int npos = number_of_vertex * 3 + pos * 3;
                int vpos = pos * 3;
                wr.m_5483_((double)this._fbuf[vpos++], (double)this._fbuf[vpos++], (double)(-this._fbuf[vpos++])).m_7421_(this._tex_array[pos].u, this._tex_array[pos].v).m_5601_(this._fbuf[npos++], this._fbuf[npos++], this._fbuf[npos++]).m_6122_(1, 1, 1, 1).m_5752_();
            }
            GL11.glEnable((int)2903);
            GL11.glColorMaterial((int)1032, (int)5634);
            GL11.glColor4f((float)mt_ptr.color[0], (float)mt_ptr.color[1], (float)mt_ptr.color[2], (float)mt_ptr.color[3]);
            if ((0x100 & mt_ptr.unknown) == 256) {
                GL11.glDisable((int)2884);
            } else {
                GL11.glEnable((int)2884);
            }
            if (mt_ptr.texture_id != null) {
                GL11.glEnable((int)3553);
                Minecraft.m_91087_().m_91290_().f_114357_.m_118506_(mt_ptr.texture_id);
            } else {
                GL11.glDisable((int)3553);
            }
            Tesselator.m_85913_().m_85914_();
        }
        GL11.glPopClientAttrib();
        GL11.glPopAttrib();
    }

    private static FloatBuffer makeFloatBuffer(int i_size) {
        ByteBuffer bb = ByteBuffer.allocateDirect(i_size * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        return fb;
    }

    private class Material {
        public float[] color;
        public float fShininess;
        public short[] indices;
        public int ulNumIndices;
        public ResourceLocation texture_id;
        public int unknown;

        private Material() {
        }
    }
}

