/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nymmd.core;

import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.struct.pmd.PMD_FACE;
import jp.nyatla.nymmd.struct.pmd.PMD_FACE_VTX;
import jp.nyatla.nymmd.types.MmdVector3;

public class PmdFace {
    private String _name;
    private PMD_FACE_VTX[] _face_vertex;

    public PmdFace(PMD_FACE pPMDFaceData, PmdFace pPMDFaceBase) {
        this._name = pPMDFaceData.szName;
        int number_of_vertex = pPMDFaceData.ulNumVertices;
        this._face_vertex = PMD_FACE_VTX.createArray(number_of_vertex);
        for (int i = 0; i < this._face_vertex.length; ++i) {
            this._face_vertex[i].setValue(pPMDFaceData.pVertices[i]);
        }
        if (pPMDFaceBase != null) {
            PMD_FACE_VTX[] vertex_array = this._face_vertex;
            for (int i = this._face_vertex.length - 1; i >= 0; --i) {
                PMD_FACE_VTX vertex = vertex_array[i];
                vertex.vec3Pos.Vector3Add(pPMDFaceBase._face_vertex[vertex.ulIndex].vec3Pos, vertex.vec3Pos);
                vertex.ulIndex = pPMDFaceBase._face_vertex[vertex.ulIndex].ulIndex;
            }
        }
    }

    public void setFace(MmdVector3[] pvec3Vertices) throws MmdException {
        if (this._face_vertex == null) {
            throw new MmdException();
        }
        PMD_FACE_VTX[] vertex_array = this._face_vertex;
        for (int i = vertex_array.length - 1; i >= 0; --i) {
            PMD_FACE_VTX vertex = vertex_array[i];
            pvec3Vertices[vertex.ulIndex].setValue(vertex.vec3Pos);
        }
    }

    public void blendFace(MmdVector3[] pvec3Vertices, float fRate) throws MmdException {
        if (this._face_vertex == null) {
            throw new MmdException();
        }
        PMD_FACE_VTX[] vertex_array = this._face_vertex;
        for (int i = vertex_array.length - 1; i >= 0; --i) {
            PMD_FACE_VTX vertex = vertex_array[i];
            MmdVector3 vec = pvec3Vertices[vertex.ulIndex];
            vec.Vector3Lerp(vec, vertex.vec3Pos, fRate);
        }
    }

    public String getName() {
        return this._name;
    }
}

