/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.Untouchable;
import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.event.handler.InputCommandEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.NBTHelper;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class SlayerStyleArts {
    static final EnumSet<InputCommand> FORWARD_SPRINT_SNEAK_COMMAND = EnumSet.of(InputCommand.FORWARD, InputCommand.SPRINT, InputCommand.SNEAK);
    static final EnumSet<InputCommand> BACK_SPRINT_SNEAK_COMMAND = EnumSet.of(InputCommand.BACK, InputCommand.SPRINT, InputCommand.SNEAK);
    static final EnumSet<InputCommand> MOVE_COMMAND = EnumSet.of(InputCommand.FORWARD, InputCommand.BACK, InputCommand.LEFT, InputCommand.RIGHT);
    public static final Vec3 BACK_MOTION = new Vec3(0.0, -5.0, 0.0);
    public static final ResourceLocation ADVANCEMENT_AIR_TRICK = SlashBlade.prefix("abilities/air_trick");
    public static final ResourceLocation ADVANCEMENT_TRICK_DOWN = SlashBlade.prefix("abilities/trick_down");
    public static final ResourceLocation ADVANCEMENT_TRICK_DODGE = SlashBlade.prefix("abilities/trick_dodge");
    public static final ResourceLocation ADVANCEMENT_TRICK_UP = SlashBlade.prefix("abilities/trick_up");
    public static final String AVOID_TRICKUP_PATH = "sb.avoid.trickup";
    public static final String AVOID_COUNTER_PATH = "sb.avoid.counter";
    public static final String AVOID_VEC_PATH = "sb.avoid.vec";
    public static final String AIRTRICK_COUNTER_PATH = "sb.airtrick.counter";
    public static final String AIRTRICK_TARGET_PATH = "sb.airtrick.target";
    public static final String STORE_STEPUP_PATH = "sb.store.stepup";
    public static final String TMP_STEPUP_PATH = "sb.tmp.stepup";
    public static final String DO_FORCE_HIT_PATH = "doForceHit";
    public static final int TRICK_ACTION_UNTOUCHABLE_TIME = 10;
    static final float stepUpBoost = 1.1f;
    static final float stepUpDefault = 0.6f;

    public static SlayerStyleArts getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private SlayerStyleArts() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onInputChange(InputCommandEvent event) {
        ServerPlayer sender = event.getEntity();
        ItemStack stack = sender.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (!(stack.m_41720_() instanceof ItemSlashBlade)) {
            return;
        }
        ServerLevel worldIn = sender.m_284548_();
        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        if (!old.contains((Object)InputCommand.SPRINT)) {
            this.processInputCommands(sender, (Level)worldIn, current);
        }
    }

    public void processInputCommands(ServerPlayer sender, Level worldIn, EnumSet<InputCommand> current) {
        boolean isHandled = false;
        if (current.containsAll(FORWARD_SPRINT_SNEAK_COMMAND)) {
            isHandled = this.handleForwardSprintSneak(sender, worldIn);
        }
        if (!isHandled && !sender.m_20096_() && current.containsAll(BACK_SPRINT_SNEAK_COMMAND)) {
            isHandled = this.handleBackSprintSneak(sender);
        }
        if (!isHandled && sender.m_20096_() && current.contains((Object)InputCommand.SPRINT)) {
            if (current.stream().anyMatch(MOVE_COMMAND::contains)) {
                this.handleSprintMove(sender, current);
            }
        }
    }

    public boolean handleForwardSprintSneak(ServerPlayer sender, Level worldIn) {
        return sender.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
            Entity target;
            Entity tmpTarget = state.getTargetEntity(worldIn);
            Object object = target = tmpTarget != null && tmpTarget.getParts() != null && tmpTarget.getParts().length > 0 ? tmpTarget.getParts()[0] : tmpTarget;
            if (target == null && sender.getPersistentData().m_128451_(AVOID_TRICKUP_PATH) == 0) {
                return this.executeTrickUp(sender);
            }
            if (target != null) {
                return this.executeAirTrick(sender, worldIn, target, (ISlashBladeState)state);
            }
            return false;
        }).orElse(false);
    }

    public boolean handleBackSprintSneak(ServerPlayer sender) {
        Vec3 oldPos = sender.m_20182_();
        sender.m_6478_(MoverType.SELF, BACK_MOTION);
        if (sender.m_20096_()) {
            this.applyFullTrickEffects(sender, BACK_MOTION, AVOID_COUNTER_PATH, ADVANCEMENT_TRICK_DOWN, 0.75f);
            return true;
        }
        sender.m_146884_(oldPos);
        return false;
    }

    public boolean handleSprintMove(ServerPlayer sender, EnumSet<InputCommand> current) {
        ServerLevel level = sender.m_284548_();
        int count = sender.getCapability(CapabilityMobEffect.MOB_EFFECT).map(effect -> effect.doAvoid(level.m_46467_())).orElse(0);
        if (count > 0) {
            this.applyBasicTrickEffects(sender);
            Vec3 input = SlayerStyleArts.getInput(current);
            sender.m_19920_(3.0f, input);
            Vec3 motion = this.maybeBackOffFromEdge(sender.m_20184_(), (LivingEntity)sender);
            sender.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, 1.2f);
            sender.m_6478_(MoverType.SELF, motion);
            sender.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(sender.m_19879_(), motion.m_82490_(0.5)));
            this.applyTrickMotionAndData(sender, motion, AVOID_COUNTER_PATH, sender.m_20182_());
            AdvancementHelper.grantCriterion(sender, ADVANCEMENT_TRICK_DODGE);
            sender.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> state.updateComboSeq((LivingEntity)sender, state.getComboRoot()));
        }
        return true;
    }

    @NotNull
    public static Vec3 getInput(EnumSet<InputCommand> current) {
        float moveForward;
        float f = current.contains((Object)InputCommand.FORWARD) ^ current.contains((Object)InputCommand.BACK) ? (current.contains((Object)InputCommand.FORWARD) ? 1.0f : -1.0f) : (moveForward = 0.0f);
        float moveStrafe = current.contains((Object)InputCommand.LEFT) ^ current.contains((Object)InputCommand.RIGHT) ? (current.contains((Object)InputCommand.LEFT) ? 1.0f : -1.0f) : 0.0f;
        return new Vec3((double)moveStrafe, 0.0, (double)moveForward);
    }

    public void applyBasicTrickEffects(ServerPlayer sender) {
        Untouchable.setUntouchable((LivingEntity)sender, 10);
        sender.f_8927_ = true;
    }

    public void applyTrickMotionAndData(ServerPlayer sender, Vec3 motion, String counterPath, Vec3 position) {
        sender.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(sender.m_19879_(), motion.m_82490_(0.75)));
        sender.getPersistentData().m_128405_(counterPath, 2);
        NBTHelper.putVector3d(sender.getPersistentData(), AVOID_VEC_PATH, position);
    }

    public void applyTrickSoundAndAdvancement(ServerPlayer sender, ResourceLocation advancement) {
        AdvancementHelper.grantCriterion(sender, advancement);
        sender.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, 1.2f);
    }

    public void applyFullTrickEffects(ServerPlayer sender, Vec3 motion, String counterPath, ResourceLocation advancement, float motionScale) {
        this.applyBasicTrickEffects(sender);
        sender.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(sender.m_19879_(), motion.m_82490_((double)motionScale)));
        sender.getPersistentData().m_128405_(counterPath, 2);
        NBTHelper.putVector3d(sender.getPersistentData(), AVOID_VEC_PATH, sender.m_20182_());
        this.applyTrickSoundAndAdvancement(sender, advancement);
    }

    public boolean executeTrickUp(ServerPlayer sender) {
        Vec3 motion = new Vec3(0.0, 0.8, 0.0);
        sender.m_6478_(MoverType.SELF, motion);
        this.applyFullTrickEffects(sender, motion, AVOID_TRICKUP_PATH, ADVANCEMENT_TRICK_UP, 0.75f);
        sender.getPersistentData().m_128405_(AVOID_COUNTER_PATH, 2);
        sender.m_6853_(false);
        return true;
    }

    public boolean executeAirTrick(ServerPlayer sender, Level worldIn, Entity target, ISlashBladeState state) {
        if (target == sender.m_21214_() && sender.f_19797_ < sender.m_21215_() + 100) {
            LivingEntity hitEntity = sender.m_21214_();
            if (hitEntity != null) {
                SlayerStyleArts.doTeleport((Entity)sender, hitEntity);
            }
        } else {
            this.createSummonedSwordForAirTrick(sender, worldIn, target, state);
        }
        return true;
    }

    public void createSummonedSwordForAirTrick(final ServerPlayer sender, Level worldIn, final Entity target, ISlashBladeState state) {
        EntityAbstractSummonedSword ss = new EntityAbstractSummonedSword(SlashBlade.RegistryEvents.SummonedSword, worldIn){

            @Override
            protected void m_5790_(EntityHitResult entityHitResult) {
                super.m_5790_(entityHitResult);
                LivingEntity hitTarget = sender.m_21214_();
                if (hitTarget != null && this.getHitEntity() == hitTarget) {
                    SlayerStyleArts.doTeleport((Entity)sender, hitTarget);
                }
            }

            @Override
            public void m_8119_() {
                if (this.getPersistentData().m_128471_(SlayerStyleArts.DO_FORCE_HIT_PATH)) {
                    this.doForceHitEntity(target);
                    this.getPersistentData().m_128473_(SlayerStyleArts.DO_FORCE_HIT_PATH);
                }
                super.m_8119_();
            }
        };
        Vec3 lastPos = sender.m_20299_(1.0f);
        ss.f_19790_ = lastPos.f_82479_;
        ss.f_19791_ = lastPos.f_82480_;
        ss.f_19792_ = lastPos.f_82481_;
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() / 2.0, 0.0).m_82549_(sender.m_20154_().m_82490_(-2.0));
        ss.m_6034_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
        Vec3 dir = sender.m_20154_();
        ss.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 1.0f, 0.0f);
        ss.m_5602_((Entity)sender);
        ss.setDamage(0.01f);
        ss.setColor(state.getColorCode());
        ss.getPersistentData().m_128379_(DO_FORCE_HIT_PATH, true);
        worldIn.m_7967_((Entity)ss);
        sender.m_6330_(SoundEvents.f_11757_, SoundSource.PLAYERS, 0.2f, 1.45f);
    }

    public static void doTeleport(Entity entityIn, LivingEntity target) {
        entityIn.getPersistentData().m_128405_(AIRTRICK_COUNTER_PATH, 3);
        entityIn.getPersistentData().m_128405_(AIRTRICK_TARGET_PATH, target.m_19879_());
        if (entityIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entityIn;
            AdvancementHelper.grantCriterion(serverPlayer, ADVANCEMENT_AIR_TRICK);
            Vec3 motion = target.m_20318_(1.0f).m_82546_(entityIn.m_20318_(1.0f)).m_82490_(0.5);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entityIn.m_19879_(), motion));
        }
    }

    public static void executeTeleport(Entity entityIn, LivingEntity target) {
        Level level = entityIn.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        SlayerStyleArts.prepareTeleportEffects(entityIn);
        Vec3 teleportPos = SlayerStyleArts.calculateTeleportPosition(entityIn, target);
        if (!SlayerStyleArts.isValidTeleportPosition(teleportPos)) {
            return;
        }
        SlayerStyleArts.performTeleportation(entityIn, serverLevel, teleportPos);
        SlayerStyleArts.applyPostTeleportEffects(entityIn);
    }

    public static void prepareTeleportEffects(Entity entityIn) {
        if (entityIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entityIn;
            serverPlayer.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 0.75f, 1.25f);
            serverPlayer.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> state.updateComboSeq((LivingEntity)serverPlayer, state.getComboRoot()));
            Untouchable.setUntouchable((LivingEntity)serverPlayer, 10);
        }
    }

    public static Vec3 calculateTeleportPosition(Entity entityIn, LivingEntity target) {
        return target.m_20182_().m_82520_(0.0, (double)target.m_20206_() / 2.0, 0.0).m_82549_(entityIn.m_20154_().m_82490_(-2.0));
    }

    public static boolean isValidTeleportPosition(Vec3 teleportPos) {
        BlockPos blockPos = new BlockPos((int)teleportPos.f_82479_, (int)teleportPos.f_82480_, (int)teleportPos.f_82481_);
        return Level.m_46741_((BlockPos)blockPos);
    }

    public static void performTeleportation(Entity entityIn, ServerLevel serverLevel, Vec3 teleportPos) {
        double x = teleportPos.f_82479_;
        double y = teleportPos.f_82480_;
        double z = teleportPos.f_82481_;
        float yaw = entityIn.m_146908_();
        float pitch = entityIn.m_146909_();
        if (entityIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entityIn;
            SlayerStyleArts.handleServerPlayerTeleportation(serverPlayer, serverLevel, x, y, z, yaw, pitch);
        } else {
            SlayerStyleArts.handleEntityTeleportation(entityIn, serverLevel, x, y, z, yaw, pitch);
        }
    }

    public static void handleServerPlayerTeleportation(ServerPlayer serverPlayer, ServerLevel serverLevel, double x, double y, double z, float yaw, float pitch) {
        Set relativeList = Collections.emptySet();
        BlockPos blockPos = new BlockPos((int)x, (int)y, (int)z);
        ChunkPos chunkPos = new ChunkPos(blockPos);
        serverLevel.m_7726_().m_8387_(TicketType.f_9448_, chunkPos, 1, (Object)serverPlayer.m_19879_());
        serverPlayer.m_8127_();
        if (serverPlayer.m_5803_()) {
            serverPlayer.m_6145_(true, true);
        }
        if (serverLevel == serverPlayer.m_9236_()) {
            serverPlayer.f_8906_.m_9780_(x, y, z, yaw, pitch, relativeList);
        } else {
            serverPlayer.m_8999_(serverLevel, x, y, z, yaw, pitch);
        }
        serverPlayer.m_5616_(yaw);
    }

    public static void handleEntityTeleportation(Entity entityIn, ServerLevel serverLevel, double x, double y, double z, float yaw, float pitch) {
        float wrappedYaw = Mth.m_14177_((float)yaw);
        float clampedPitch = Mth.m_14036_((float)Mth.m_14177_((float)pitch), (float)-90.0f, (float)90.0f);
        if (serverLevel == entityIn.m_9236_()) {
            entityIn.m_7678_(x, y, z, wrappedYaw, clampedPitch);
            entityIn.m_5616_(wrappedYaw);
        } else {
            SlayerStyleArts.handleCrossDimensionTeleport(entityIn, serverLevel, x, y, z, wrappedYaw, clampedPitch);
        }
    }

    public static void handleCrossDimensionTeleport(Entity entityIn, ServerLevel serverLevel, double x, double y, double z, float yaw, float pitch) {
        entityIn.m_19877_();
        Entity newEntity = entityIn.m_6095_().m_20615_((Level)serverLevel);
        if (newEntity != null) {
            newEntity.m_20361_(entityIn);
            newEntity.m_7678_(x, y, z, yaw, pitch);
            newEntity.m_5616_(yaw);
        }
    }

    public static void applyPostTeleportEffects(Entity entityIn) {
        if (!(entityIn instanceof LivingEntity) || !((LivingEntity)entityIn).m_21255_()) {
            entityIn.m_20256_(entityIn.m_20184_().m_82542_(1.0, 0.0, 1.0));
            entityIn.m_6853_(false);
        }
        if (entityIn instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)entityIn;
            pathfinderMob.m_21573_().m_26573_();
        }
    }

    protected Vec3 maybeBackOffFromEdge(Vec3 vec, LivingEntity mover) {
        double d0 = vec.f_82479_;
        double d1 = vec.f_82481_;
        while (d0 != 0.0 && mover.m_9236_().m_45756_((Entity)mover, mover.m_20191_().m_82386_(d0, (double)(-mover.m_274421_()), 0.0))) {
            if (d0 < 0.05 && d0 >= -0.05) {
                d0 = 0.0;
                continue;
            }
            if (d0 > 0.0) {
                d0 -= 0.05;
                continue;
            }
            d0 += 0.05;
        }
        while (d1 != 0.0 && mover.m_9236_().m_45756_((Entity)mover, mover.m_20191_().m_82386_(0.0, (double)(-mover.m_274421_()), d1))) {
            if (d1 < 0.05 && d1 >= -0.05) {
                d1 = 0.0;
                continue;
            }
            if (d1 > 0.0) {
                d1 -= 0.05;
                continue;
            }
            d1 += 0.05;
        }
        while (d0 != 0.0 && d1 != 0.0 && mover.m_9236_().m_45756_((Entity)mover, mover.m_20191_().m_82386_(d0, (double)(-mover.m_274421_()), d1))) {
            d0 = d0 < 0.05 && d0 >= -0.05 ? 0.0 : (d0 > 0.0 ? (d0 -= 0.05) : (d0 += 0.05));
            if (d1 < 0.05 && d1 >= -0.05) {
                d1 = 0.0;
                continue;
            }
            if (d1 > 0.0) {
                d1 -= 0.05;
                continue;
            }
            d1 += 0.05;
        }
        vec = new Vec3(d0, vec.f_82480_, d1);
        return vec;
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        switch (event.phase) {
            case START: {
                this.handleTickStart(event);
                break;
            }
            case END: {
                this.handleTickEnd(event);
            }
        }
    }

    public void handleTickStart(TickEvent.PlayerTickEvent event) {
        this.handleStepUpBoost(event.player);
        this.handleTrickUpCooldown(event.player);
        this.handleAvoidCounter(event.player);
        this.handleAirTrickCounter(event.player);
    }

    public void handleStepUpBoost(Player player) {
        float stepUp = player.m_274421_();
        boolean doStepupBoost = this.shouldApplyStepUpBoost(player);
        if (doStepupBoost && player.m_21205_().m_41720_() instanceof ItemSlashBlade && stepUp < 1.1f) {
            player.getPersistentData().m_128350_(STORE_STEPUP_PATH, stepUp);
            player.m_274367_(1.1f);
        }
    }

    public boolean shouldApplyStepUpBoost(Player player) {
        Vec3 deltaMovement = this.calculatePlayerMovement(player);
        if (deltaMovement.equals((Object)Vec3.f_82478_)) {
            return false;
        }
        Vec3 offset = deltaMovement.m_82541_().m_82490_(0.5).m_82520_(0.0, 0.25, 0.0);
        BlockPos offsetPos = new BlockPos(VectorHelper.f2i(player.m_20182_().m_82549_(offset))).m_7495_();
        BlockState blockState = player.m_9236_().m_8055_(offsetPos);
        boolean liquid = !blockState.m_278721_();
        return liquid;
    }

    public Vec3 calculatePlayerMovement(Player player) {
        Vec3 input = new Vec3((double)player.f_20900_, (double)player.f_20901_, (double)player.f_20902_);
        double scale = 1.0;
        float yRot = player.m_146908_();
        double d0 = input.m_82556_();
        if (d0 < 1.0E-7) {
            return Vec3.f_82478_;
        }
        Vec3 vec3 = (d0 > 1.0 ? input.m_82541_() : input).m_82490_(scale);
        float f = Mth.m_14031_((float)(yRot * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(yRot * ((float)Math.PI / 180)));
        return new Vec3(vec3.f_82479_ * (double)f1 - vec3.f_82481_ * (double)f, vec3.f_82480_, vec3.f_82481_ * (double)f1 + vec3.f_82479_ * (double)f);
    }

    public void handleTrickUpCooldown(Player player) {
        if (!player.m_20096_() || !player.getPersistentData().m_128441_(AVOID_TRICKUP_PATH)) {
            return;
        }
        int count = player.getPersistentData().m_128451_(AVOID_TRICKUP_PATH) - 1;
        if (count <= 0) {
            player.getPersistentData().m_128473_(AVOID_TRICKUP_PATH);
            this.triggerDimensionChange(player);
        } else {
            player.getPersistentData().m_128405_(AVOID_TRICKUP_PATH, count);
        }
    }

    public void handleAvoidCounter(Player player) {
        if (!player.getPersistentData().m_128441_(AVOID_COUNTER_PATH)) {
            return;
        }
        int count = player.getPersistentData().m_128451_(AVOID_COUNTER_PATH) - 1;
        if (count <= 0) {
            this.restoreAvoidPosition(player);
            this.clearAvoidData(player);
            this.triggerDimensionChange(player);
        } else {
            player.getPersistentData().m_128405_(AVOID_COUNTER_PATH, count);
        }
    }

    public void restoreAvoidPosition(Player player) {
        if (player.getPersistentData().m_128441_(AVOID_VEC_PATH)) {
            Vec3 pos = NBTHelper.getVector3d(player.getPersistentData(), AVOID_VEC_PATH);
            player.m_20219_(pos);
        }
    }

    public void clearAvoidData(Player player) {
        player.getPersistentData().m_128473_(AVOID_COUNTER_PATH);
        player.getPersistentData().m_128473_(AVOID_VEC_PATH);
    }

    public void handleAirTrickCounter(Player player) {
        if (!player.getPersistentData().m_128441_(AIRTRICK_COUNTER_PATH)) {
            return;
        }
        int count = player.getPersistentData().m_128451_(AIRTRICK_COUNTER_PATH) - 1;
        if (count <= 0) {
            this.executeAirTrickTeleport(player);
            this.clearAirTrickData(player);
            this.triggerDimensionChange(player);
        } else {
            player.getPersistentData().m_128405_(AIRTRICK_COUNTER_PATH, count);
        }
    }

    public void executeAirTrickTeleport(Player player) {
        if (!player.getPersistentData().m_128441_(AIRTRICK_TARGET_PATH)) {
            return;
        }
        int id = player.getPersistentData().m_128451_(AIRTRICK_TARGET_PATH);
        Entity target = player.m_9236_().m_6815_(id);
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            SlayerStyleArts.executeTeleport((Entity)player, livingEntity);
        }
    }

    public void clearAirTrickData(Player player) {
        player.getPersistentData().m_128473_(AIRTRICK_COUNTER_PATH);
        player.getPersistentData().m_128473_(AIRTRICK_TARGET_PATH);
    }

    public void triggerDimensionChange(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_8959_();
        }
    }

    public void handleTickEnd(TickEvent.PlayerTickEvent event) {
        float stepUp = event.player.getPersistentData().m_128457_(TMP_STEPUP_PATH);
        if ((stepUp = Math.max(stepUp, 0.6f)) < event.player.m_274421_()) {
            event.player.m_274367_(stepUp);
        }
    }

    private static final class SingletonHolder {
        private static final SlayerStyleArts INSTANCE = new SlayerStyleArts();

        private SingletonHolder() {
        }
    }
}

