/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.EnumSet;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BladeItemEntityRenderer
extends ItemEntityRenderer {
    public BladeItemEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldSpreadItems() {
        return false;
    }

    public boolean shouldBob() {
        return false;
    }

    public void m_7392_(ItemEntity itemIn, float entityYaw, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        this.f_114477_ = 0.0f;
        if (!itemIn.m_32055_().m_41619_()) {
            this.renderBlade(itemIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        } else {
            partialTicks = (float)((double)itemIn.f_31983_ * 20.0 - (double)itemIn.m_32059_());
            super.m_7392_(itemIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    private void renderBlade(ItemEntity itemIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        block29: {
            if (itemIn instanceof BladeItemEntity) {
                BladeItemEntity bladeItem = (BladeItemEntity)itemIn;
                try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStackIn);){
                    matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(entityYaw));
                    ItemStack current = itemIn.m_32055_();
                    EnumSet<SwordType> types = SwordType.from(current);
                    itemIn.getPersistentData();
                    ResourceLocation modelLocation = current.getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getModel().orElseGet(bladeItem::getModel)).orElseGet(bladeItem::getModel);
                    ResourceLocation textureLocation = current.getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getTexture().orElseGet(bladeItem::getTexture)).orElseGet(bladeItem::getTexture);
                    WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
                    float scale = 0.00625f;
                    try (MSAutoCloser msac2 = MSAutoCloser.pushMatrix(matrixStackIn);){
                        String renderTarget;
                        float xOffset;
                        float heightOffset;
                        if (types.contains((Object)SwordType.EDGEFRAGMENT)) {
                            heightOffset = 225.0f;
                            xOffset = 200.0f;
                            renderTarget = "blade_fragment";
                        } else if (types.contains((Object)SwordType.BROKEN)) {
                            heightOffset = 100.0f;
                            xOffset = 30.0f;
                            renderTarget = "blade_damaged";
                        } else {
                            heightOffset = 225.0f;
                            xOffset = 120.0f;
                            renderTarget = "blade";
                        }
                        if (itemIn.m_20069_()) {
                            matrixStackIn.m_252880_(0.0f, 0.025f, 0.0f);
                            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(itemIn.f_31983_));
                            matrixStackIn.m_85841_(scale, scale, scale);
                            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                        } else if (!itemIn.m_20096_()) {
                            matrixStackIn.m_85841_(scale, scale, scale);
                            float speed = -81.0f;
                            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(speed * ((float)itemIn.f_19797_ + partialTicks)));
                            matrixStackIn.m_252880_(xOffset, 0.0f, 0.0f);
                        } else {
                            matrixStackIn.m_85841_(scale, scale, scale);
                            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(60.0f + (float)Math.toDegrees((double)itemIn.f_31983_ / 6.0)));
                            matrixStackIn.m_252880_(heightOffset, 0.0f, 0.0f);
                        }
                        BladeRenderState.renderOverrided(current, model, renderTarget, textureLocation, matrixStackIn, bufferIn, packedLightIn);
                        BladeRenderState.renderOverridedLuminous(current, model, renderTarget + "_luminous", textureLocation, matrixStackIn, bufferIn, packedLightIn);
                    }
                    if (!itemIn.m_20069_() && (!itemIn.m_20096_() || types.contains((Object)SwordType.NOSCABBARD))) break block29;
                    msac2 = MSAutoCloser.pushMatrix(matrixStackIn);
                    try {
                        matrixStackIn.m_252880_(0.0f, 0.025f, 0.0f);
                        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(itemIn.f_31983_));
                        if (!itemIn.m_20069_()) {
                            matrixStackIn.m_85837_(0.75, 0.0, -0.4);
                        }
                        matrixStackIn.m_85841_(scale, scale, scale);
                        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                        String renderTarget = "sheath";
                        BladeRenderState.renderOverrided(current, model, renderTarget, textureLocation, matrixStackIn, bufferIn, packedLightIn);
                        BladeRenderState.renderOverridedLuminous(current, model, renderTarget + "_luminous", textureLocation, matrixStackIn, bufferIn, packedLightIn);
                    }
                    finally {
                        if (msac2 != null) {
                            msac2.close();
                        }
                    }
                }
            }
        }
    }
}

