/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DriveRenderer<T extends EntityDrive>
extends EntityRenderer<T> {
    private static final ResourceLocation TEXTURE = SlashBlade.prefix("model/util/ss.png");
    private static final ResourceLocation MODEL = SlashBlade.prefix("model/util/drive.obj");

    @NotNull
    public ResourceLocation getTextureLocation(T entity) {
        return ((EntityAbstractSummonedSword)entity).getTextureLoc();
    }

    public DriveRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack matrixStack, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack);){
            float lifetime = ((EntityDrive)entity).getLifetime();
            double deathTime = lifetime;
            double baseAlpha = Math.min(deathTime, (double)Math.max(0.0f, lifetime - (float)((EntityDrive)entity).f_19797_)) / deathTime;
            baseAlpha = Math.max(0.0, -Math.pow(baseAlpha - 1.0, 4.0) + 0.75);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14189_((float)partialTicks, (float)((EntityDrive)entity).f_19859_, (float)entity.m_146908_()) - 90.0f));
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14189_((float)partialTicks, (float)((EntityDrive)entity).f_19860_, (float)entity.m_146909_())));
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(((EntityDrive)entity).getRotationRoll()));
            float scale = 0.015f;
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            int color = ((EntityDrive)entity).getColor() & 0xFFFFFF;
            int alpha = (0xFF & (int)(255.0 * baseAlpha)) << 24;
            WavefrontObject model = BladeModelManager.getInstance().getModel(MODEL);
            BladeRenderState.setCol(color | alpha);
            BladeRenderState.renderOverridedLuminous(ItemStack.f_41583_, model, "base", TEXTURE, matrixStack, bufferIn, packedLightIn);
        }
    }
}

