/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.EntityJudgementCut;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class JudgementCutRenderer<T extends EntityJudgementCut>
extends EntityRenderer<T> {
    private static final ResourceLocation modelLocation = new ResourceLocation("slashblade", "model/util/slashdim.obj");
    private static final ResourceLocation textureLocation = new ResourceLocation("slashblade", "model/util/slashdim.png");

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        return textureLocation;
    }

    public JudgementCutRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStackIn);){
            int l;
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)((EntityJudgementCut)entity).f_19859_, (float)entity.m_146908_()) - 90.0f));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)partialTicks, (float)((EntityJudgementCut)entity).f_19860_, (float)entity.m_146909_())));
            WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
            int lifetime = ((EntityJudgementCut)entity).getLifetime();
            double deathTime = lifetime;
            double baseAlpha = Math.min(deathTime, (double)Math.max(0.0f, (float)(lifetime - ((EntityJudgementCut)entity).f_19797_) - partialTicks)) / deathTime;
            baseAlpha = -Math.pow(baseAlpha - 1.0, 4.0) + 1.0;
            int seed = ((EntityJudgementCut)entity).getSeed();
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_((float)seed));
            float scale = 0.01f;
            matrixStackIn.m_85841_(scale, scale, scale);
            int color = ((EntityJudgementCut)entity).getColor() & 0xFFFFFF;
            Color col = new Color(color);
            float[] hsb = Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), null);
            int baseColor = Color.HSBtoRGB(0.5f + hsb[0], hsb[1], 0.2f) & 0xFFFFFF;
            try (MSAutoCloser msacB = MSAutoCloser.pushMatrix(matrixStackIn);){
                for (l = 0; l < 5; ++l) {
                    matrixStackIn.m_85841_(0.95f, 0.95f, 0.95f);
                    BladeRenderState.setCol(baseColor | (0xFF & (int)(102.0 * baseAlpha)) << 24);
                    BladeRenderState.renderOverridedReverseLuminous(ItemStack.f_41583_, model, "base", this.getTextureLocation(entity), matrixStackIn, bufferIn, packedLightIn);
                }
            }
            int loop = 3;
            for (l = 0; l < loop; ++l) {
                try (MSAutoCloser msacB = MSAutoCloser.pushMatrix(matrixStackIn);){
                    float cycleTicks = 15.0f;
                    float wave = ((float)((EntityJudgementCut)entity).f_19797_ + cycleTicks / (float)loop * (float)l + partialTicks) % cycleTicks;
                    float waveScale = 1.0f + 0.03f * wave;
                    matrixStackIn.m_85841_(waveScale, waveScale, waveScale);
                    BladeRenderState.setCol(baseColor | (int)((double)(136.0f * ((cycleTicks - wave) / cycleTicks)) * baseAlpha) << 24);
                    BladeRenderState.renderOverridedReverseLuminous(ItemStack.f_41583_, model, "base", this.getTextureLocation(entity), matrixStackIn, bufferIn, packedLightIn);
                    continue;
                }
            }
            int windCount = 5;
            for (int l2 = 0; l2 < windCount; ++l2) {
                try (MSAutoCloser msacB = MSAutoCloser.pushMatrix(matrixStackIn);){
                    matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(360.0f / (float)windCount * (float)l2));
                    matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(30.0f));
                    double rotWind = 18.0;
                    double offsetBase = 7.0;
                    double offset = (double)l2 * offsetBase;
                    double motionLen = offsetBase * (double)(windCount - 1);
                    double ticks = (float)((EntityJudgementCut)entity).f_19797_ + partialTicks + (float)seed;
                    double offsetTicks = ticks + offset;
                    double progress = offsetTicks % motionLen / motionLen;
                    double rad = Math.PI * 2;
                    float windScale = (float)(0.4 + progress);
                    matrixStackIn.m_85841_(windScale, windScale, windScale);
                    matrixStackIn.m_252781_(Axis.f_252403_.m_252977_((float)(rotWind * offsetTicks)));
                    Color cc = new Color(col.getRed(), col.getGreen(), col.getBlue(), 0xFF & (int)Math.min(0.0, 255.0 * Math.sin(rad *= progress) * baseAlpha));
                    BladeRenderState.setCol(cc);
                    BladeRenderState.renderOverridedColorWrite(ItemStack.f_41583_, model, "wind", this.getTextureLocation(entity), matrixStackIn, bufferIn, 0xF000E0);
                    continue;
                }
            }
        }
    }
}

