/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BladeModelManager {
    public WavefrontObject defaultModel = new WavefrontObject(DefaultResources.resourceDefaultModel);
    public LoadingCache<ResourceLocation, WavefrontObject> cache = CacheBuilder.newBuilder().build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<ResourceLocation, WavefrontObject>(){

        @NotNull
        public WavefrontObject load(@NotNull ResourceLocation key) {
            try {
                return new WavefrontObject(key);
            }
            catch (Exception e) {
                return BladeModelManager.this.defaultModel;
            }
        }
    }, (Executor)Executors.newCachedThreadPool()));

    public static BladeModelManager getInstance() {
        return SingletonHolder.instance;
    }

    public static Registry<SlashBladeDefinition> getClientSlashBladeRegistry() {
        return Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_105152_().m_175515_(SlashBladeDefinition.REGISTRY_KEY);
    }

    private BladeModelManager() {
    }

    public WavefrontObject getModel(ResourceLocation loc) {
        if (loc != null) {
            try {
                return (WavefrontObject)this.cache.get((Object)loc);
            }
            catch (Exception e) {
                SlashBlade.LOGGER.warn((Object)e);
            }
        }
        return this.defaultModel;
    }

    private static final class SingletonHolder {
        private static final BladeModelManager instance = new BladeModelManager();

        private SingletonHolder() {
        }
    }
}

