/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.model.obj;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BiFunction;
import mods.flammpfeil.slashblade.client.renderer.model.obj.TextureCoordinate;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Vertex;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Face {
    public static final BiFunction<Vector4f, Integer, Integer> alphaNoOverride = (v, a) -> a;
    public static final BiFunction<Vector4f, Integer, Integer> alphaOverrideYZZ = (v, a) -> v.y() == 0.0f ? 0 : a;
    public static BiFunction<Vector4f, Integer, Integer> alphaOverride = alphaNoOverride;
    public static final Vector4f uvDefaultOperator;
    public static Vector4f uvOperator;
    public Vertex[] vertices;
    public Vertex[] vertexNormals;
    public Vertex faceNormal;
    public TextureCoordinate[] textureCoordinates;

    public static void setAlphaOverride(BiFunction<Vector4f, Integer, Integer> alphaOverride) {
        Face.alphaOverride = alphaOverride;
    }

    public static void resetAlphaOverride() {
        alphaOverride = alphaNoOverride;
    }

    public static void setUvOperator(float uScale, float vScale, float uOffset, float vOffset) {
        uvOperator = new Vector4f(uScale, vScale, uOffset, vOffset);
    }

    public static void resetUvOperator() {
        uvOperator = uvDefaultOperator;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(VertexConsumer tessellator, PoseStack matrixStack, int light, int color) {
        this.addFaceForRender(tessellator, 5.0E-4f, matrixStack.m_85850_().m_252922_(), light, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(VertexConsumer tessellator, float textureOffset, Matrix4f transform, int light, int color) {
        if (this.faceNormal == null) {
            this.faceNormal = this.calculateFaceNormal();
        }
        float averageU = 0.0f;
        float averageV = 0.0f;
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            for (TextureCoordinate textureCoordinate : this.textureCoordinates) {
                averageU += textureCoordinate.u * uvOperator.x() + uvOperator.z();
                averageV += textureCoordinate.v * uvOperator.y() + uvOperator.w();
            }
            averageU /= (float)this.textureCoordinates.length;
            averageV /= (float)this.textureCoordinates.length;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            this.putVertex(tessellator, i, transform, textureOffset, averageU, averageV, light, color);
        }
    }

    void putVertex(VertexConsumer wr, int i, Matrix4f transform, float textureOffset, float averageU, float averageV, int light, int color) {
        Vector3f vector3f;
        wr.m_252986_(transform, this.vertices[i].x, this.vertices[i].y, this.vertices[i].z);
        wr.m_6122_(FastColor.ARGB32.m_13665_((int)color), FastColor.ARGB32.m_13667_((int)color), FastColor.ARGB32.m_13669_((int)color), alphaOverride.apply(new Vector4f(this.vertices[i].x, this.vertices[i].y, this.vertices[i].z, 1.0f), FastColor.ARGB32.m_13655_((int)color)).intValue());
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            float offsetU = textureOffset;
            float offsetV = textureOffset;
            float textureU = this.textureCoordinates[i].u * uvOperator.x() + uvOperator.z();
            float textureV = this.textureCoordinates[i].v * uvOperator.y() + uvOperator.w();
            if (textureU > averageU) {
                offsetU = -offsetU;
            }
            if (textureV > averageV) {
                offsetV = -offsetV;
            }
            wr.m_7421_(textureU + offsetU, textureV + offsetV);
        } else {
            wr.m_7421_(0.0f, 0.0f);
        }
        wr.m_86008_(OverlayTexture.f_118083_);
        wr.m_85969_(light);
        if (this.vertexNormals != null) {
            Vertex normal = this.vertexNormals[i];
            vector3f = new Vector3f(normal.x, normal.y, normal.z);
        } else {
            vector3f = new Vector3f(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z);
        }
        vector3f.mul((Matrix3fc)new Matrix3f((Matrix4fc)transform));
        vector3f.normalize();
        wr.m_5601_(vector3f.x(), vector3f.y(), vector3f.z());
        wr.m_5752_();
    }

    public Vertex calculateFaceNormal() {
        Vec3 v1 = new Vec3((double)(this.vertices[1].x - this.vertices[0].x), (double)(this.vertices[1].y - this.vertices[0].y), (double)(this.vertices[1].z - this.vertices[0].z));
        Vec3 v2 = new Vec3((double)(this.vertices[2].x - this.vertices[0].x), (double)(this.vertices[2].y - this.vertices[0].y), (double)(this.vertices[2].z - this.vertices[0].z));
        Vec3 normalVector = v1.m_82537_(v2).m_82541_();
        return new Vertex((float)normalVector.f_82479_, (float)normalVector.f_82480_, (float)normalVector.f_82481_);
    }

    static {
        uvOperator = uvDefaultOperator = new Vector4f(1.0f, 1.0f, 0.0f, 0.0f);
    }
}

