/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Face;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.event.client.RenderOverrideEvent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;

public class BladeRenderState
extends RenderStateShard {
    private static final Color defaultColor;
    private static Color col;
    public static final int MAX_LIGHT = 0xF000E0;
    private static final Map<ResourceLocation, RenderType> slashBladeBlendCache;
    private static final Map<ResourceLocation, RenderType> slashBladeBlendColorWriteCache;
    private static final Map<ResourceLocation, RenderType> slashBladeBlendLuminousCache;
    private static final Map<ChargeEffectKey, RenderType> chargeEffectCache;
    private static final Map<ResourceLocation, RenderType> luminousDepthWriteCache;
    private static final Map<ResourceLocation, RenderType> reverseLuminousCache;
    public static final RenderType SLASHBLADE_GLINT;
    public static final RenderType SLASHBLADE_ITEM_GLINT;
    protected static final RenderStateShard.TransparencyStateShard LIGHTNING_ADDITIVE_TRANSPARENCY;
    protected static final RenderStateShard.TransparencyStateShard LIGHTNING_REVERSE_TRANSPARENCY;

    public static void setCol(int rgba) {
        BladeRenderState.setCol(rgba, true);
    }

    public static void setCol(int rgb, boolean hasAlpha) {
        BladeRenderState.setCol(new Color(rgb, hasAlpha));
    }

    public static void setCol(Color value) {
        col = value;
    }

    public static void resetCol() {
        col = defaultColor;
    }

    public BladeRenderState(String p_i225973_1_, Runnable p_i225973_2_, Runnable p_i225973_3_) {
        super(p_i225973_1_, p_i225973_2_, p_i225973_3_);
    }

    public static void renderOverrided(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, BladeRenderState::getSlashBladeBlend, true);
    }

    public static void renderOverridedColorWrite(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, BladeRenderState::getSlashBladeBlendColorWrite, true);
    }

    public static void renderChargeEffect(ItemStack stack, float f, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, loc -> BladeRenderState.getChargeEffect(loc, f * 0.1f % 1.0f, f * 0.01f % 1.0f), false);
    }

    public static void renderOverridedLuminous(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, BladeRenderState::getSlashBladeBlendLuminous, false);
    }

    public static void renderOverridedLuminousDepthWrite(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, BladeRenderState::getSlashBladeBlendLuminousDepthWrite, false);
    }

    public static void renderOverridedReverseLuminous(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, BladeRenderState::getSlashBladeBlendReverseLuminous, false);
    }

    public static void renderOverrided(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Function<ResourceLocation, RenderType> getRenderType, boolean enableEffect) {
        RenderOverrideEvent event = RenderOverrideEvent.onRenderOverride(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, getRenderType, enableEffect);
        if (event.isCanceled()) {
            return;
        }
        ResourceLocation loc = event.getTexture();
        RenderType rt = event.getGetRenderType().apply(loc);
        VertexConsumer vb = bufferIn.m_6299_(rt);
        int color = FastColor.ARGB32.m_13660_((int)col.getAlpha(), (int)col.getRed(), (int)col.getGreen(), (int)col.getBlue());
        event.getModel().tessellateOnly(vb, matrixStackIn, event.getPackedLightIn(), color, event.getTarget());
        if (stack.m_41790_() && event.isEnableEffect()) {
            vb = bufferIn.m_6299_(target.startsWith("item_") ? SLASHBLADE_ITEM_GLINT : SLASHBLADE_GLINT);
            event.getModel().tessellateOnly(vb, matrixStackIn, event.getPackedLightIn(), color, event.getTarget());
        }
        Face.resetAlphaOverride();
        Face.resetUvOperator();
        BladeRenderState.resetCol();
    }

    public static RenderType getSlashBladeBlend(ResourceLocation texture) {
        return slashBladeBlendCache.computeIfAbsent(texture, t -> {
            RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173064_).m_110675_(RenderStateShard.f_110129_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(t, false, true)).m_110685_(RenderStateShard.f_110139_).m_110671_(f_110152_).m_110677_(f_110154_).m_110687_(RenderStateShard.f_110114_).m_110691_(true);
            return RenderType.m_173215_((String)("slashblade_blend_" + t), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
        });
    }

    public static RenderType getSlashBladeGlint() {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ItemRenderer.f_273897_, true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110675_(f_110129_).m_110683_(f_110151_).m_110677_(f_110154_).m_110691_(false);
        return RenderType.m_173215_((String)"slashblade_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getSlashBladeItemGlint() {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ItemRenderer.f_273833_, true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110675_(f_110129_).m_110683_(f_110150_).m_110677_(f_110154_).m_110691_(false);
        return RenderType.m_173215_((String)"slashblade_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getSlashBladeBlendColorWrite(ResourceLocation texture) {
        return slashBladeBlendColorWriteCache.computeIfAbsent(texture, t -> {
            RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_234323_).m_110675_(RenderStateShard.f_110129_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(t, false, true)).m_110685_(LIGHTNING_ADDITIVE_TRANSPARENCY).m_110671_(f_110152_).m_110677_(f_110154_).m_110687_(f_110115_).m_110691_(false);
            return RenderType.m_173215_((String)("slashblade_blend_write_color_" + t), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
        });
    }

    public static RenderType getSlashBladeBlendLuminous(ResourceLocation texture) {
        return slashBladeBlendLuminousCache.computeIfAbsent(texture, t -> {
            RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_234323_).m_110675_(f_110129_).m_110661_(RenderStateShard.f_110110_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(t, true, true)).m_110685_(LIGHTNING_ADDITIVE_TRANSPARENCY).m_110671_(RenderStateShard.f_110152_).m_110677_(f_110154_).m_110687_(f_110115_).m_110691_(false);
            return RenderType.m_173215_((String)("slashblade_blend_luminous_" + t), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
        });
    }

    public static RenderType getChargeEffect(ResourceLocation texture, float x, float y) {
        ChargeEffectKey key = new ChargeEffectKey(texture, x, y);
        return chargeEffectCache.computeIfAbsent(key, k -> {
            RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173074_).m_110675_(f_110129_).m_110661_(RenderStateShard.f_110110_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(k.texture, false, true)).m_110683_((RenderStateShard.TexturingStateShard)new RenderStateShard.OffsetTexturingStateShard(k.x, k.y)).m_110685_(LIGHTNING_ADDITIVE_TRANSPARENCY).m_110671_(RenderStateShard.f_110152_).m_110677_(f_110154_).m_110687_(RenderStateShard.f_110115_).m_110691_(false);
            return RenderType.m_173215_((String)("slashblade_charge_effect_" + k.texture + "_" + k.x + "_" + k.y), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
        });
    }

    public static RenderType getSlashBladeBlendLuminousDepthWrite(ResourceLocation texture) {
        return luminousDepthWriteCache.computeIfAbsent(texture, t -> {
            RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_234323_).m_110675_(RenderStateShard.f_110126_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(t, true, true)).m_110685_(LIGHTNING_ADDITIVE_TRANSPARENCY).m_110671_(RenderStateShard.f_110152_).m_110677_(f_110154_).m_110687_(f_110114_).m_110691_(false);
            return RenderType.m_173215_((String)("slashblade_blend_luminous_depth_write_" + t), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
        });
    }

    public static RenderType getSlashBladeBlendReverseLuminous(ResourceLocation texture) {
        return reverseLuminousCache.computeIfAbsent(texture, t -> {
            RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_234323_).m_110675_(RenderStateShard.f_110129_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(t, true, true)).m_110685_(LIGHTNING_REVERSE_TRANSPARENCY).m_110671_(RenderStateShard.f_110152_).m_110677_(f_110154_).m_110687_(f_110115_).m_110691_(false);
            return RenderType.m_173215_((String)("slashblade_blend_reverse_luminous_" + t), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
        });
    }

    static {
        col = defaultColor = Color.white;
        slashBladeBlendCache = new HashMap<ResourceLocation, RenderType>();
        slashBladeBlendColorWriteCache = new HashMap<ResourceLocation, RenderType>();
        slashBladeBlendLuminousCache = new HashMap<ResourceLocation, RenderType>();
        chargeEffectCache = new HashMap<ChargeEffectKey, RenderType>();
        luminousDepthWriteCache = new HashMap<ResourceLocation, RenderType>();
        reverseLuminousCache = new HashMap<ResourceLocation, RenderType>();
        SLASHBLADE_GLINT = BladeRenderState.getSlashBladeGlint();
        SLASHBLADE_ITEM_GLINT = BladeRenderState.getSlashBladeItemGlint();
        LIGHTNING_ADDITIVE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("lightning_additive_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        LIGHTNING_REVERSE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("lightning_reverse_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.blendEquation((int)32779);
        }, () -> {
            RenderSystem.blendEquation((int)32774);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
    }

    private record ChargeEffectKey(ResourceLocation texture, float x, float y) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChargeEffectKey that = (ChargeEffectKey)o;
            return Float.compare(that.x, this.x) == 0 && Float.compare(that.y, this.y) == 0 && this.texture.equals((Object)that.texture);
        }
    }
}

