/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.compat.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.HashSet;
import java.util.List;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.compat.emi.SlashBladeSmithingEmiRecipe;
import mods.flammpfeil.slashblade.recipe.SlashBladeSmithingRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@EmiEntrypoint
public class EMICompat
implements EmiPlugin {
    public static final EmiRecipeCategory SLASHBLADE_SMITHING_CATEGORY = new EmiRecipeCategory(SlashBlade.prefix("slashblade_smithing"), (EmiRenderable)EmiStack.of((ItemLike)Blocks.f_50625_));
    public static final EmiRecipeCategory SLASHBLADE_SHAPED_CATEGORY = new EmiRecipeCategory(SlashBlade.prefix("shaped_blade"), (EmiRenderable)EmiStack.of((ItemLike)Blocks.f_50091_));

    public void register(EmiRegistry registry) {
        registry.addCategory(SLASHBLADE_SMITHING_CATEGORY);
        registry.addCategory(SLASHBLADE_SHAPED_CATEGORY);
        HashSet<ResourceLocation> vanillaSmithing = new HashSet<ResourceLocation>();
        List<SlashBladeSmithingRecipe> smithingRecipes = EMICompat.findRecipesByType(RecipeType.f_44113_).stream().filter(r -> r instanceof SlashBladeSmithingRecipe).map(r -> (SlashBladeSmithingRecipe)r).toList();
        for (SlashBladeSmithingRecipe recipe : smithingRecipes) {
            registry.addRecipe((EmiRecipe)new SlashBladeSmithingEmiRecipe(recipe));
            vanillaSmithing.add(recipe.m_6423_());
        }
        registry.removeRecipes(emiRecipe -> vanillaSmithing.contains(emiRecipe.getId()) && !(emiRecipe instanceof SlashBladeSmithingEmiRecipe));
        registry.addWorkstation(SLASHBLADE_SMITHING_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50625_));
        registry.removeRecipes(ResourceLocation.m_135820_((String)"emi:/crafting/repairing/slashblade/slashblade"));
    }

    private static <C extends Container, T extends Recipe<C>> List<T> findRecipesByType(RecipeType<T> type) {
        Minecraft instance = Minecraft.m_91087_();
        if (instance.f_91073_ != null) {
            return instance.f_91073_.m_7465_().m_44013_(type);
        }
        return List.of();
    }
}

