/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.compat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.IExtendableSmithingRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.compat.jei.SlashBladeSmithingCategoryExtension;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.recipe.SlashBladeSmithingRecipe;
import mods.flammpfeil.slashblade.registry.SlashBladeItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return SlashBlade.prefix("slashblade");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)SlashBladeItems.SLASHBLADE.get(), JEICompat::syncSlashBlade);
    }

    public static String syncSlashBlade(ItemStack stack, UidContext context) {
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(cap -> {
            if (stack.m_41784_().m_128441_("bladeState")) {
                cap.deserializeNBT(stack.m_41784_().m_128469_("bladeState"));
            }
        });
        return stack.getCapability(ItemSlashBlade.BLADESTATE).map(ISlashBladeState::getTranslationKey).orElse("");
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        IExtendableSmithingRecipeCategory smithingCategory = registration.getSmithingCategory();
        smithingCategory.addExtension(SlashBladeSmithingRecipe.class, (ISmithingCategoryExtension)new SlashBladeSmithingCategoryExtension());
    }
}

