/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.handler;

import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FallHandler {
    public static FallHandler getInstance() {
        return SingletonHolder.instance;
    }

    private FallHandler() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        FallHandler.resetState(event.getEntity());
    }

    @SubscribeEvent
    public void onFlyableFall(PlayerFlyableFallEvent event) {
        FallHandler.resetState((LivingEntity)event.getEntity());
    }

    public static void resetState(LivingEntity user) {
        user.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            ComboState combo;
            state.setFallDecreaseRate(0.0f);
            ComboState comboState = combo = ComboStateRegistry.REGISTRY.get().getValue(state.getComboSeq()) != null ? (ComboState)ComboStateRegistry.REGISTRY.get().getValue(state.getComboSeq()) : (ComboState)ComboStateRegistry.NONE.get();
            if (combo != null && combo.isAerial()) {
                state.setComboSeq(combo.getNextOfTimeout(user));
            }
        });
    }

    public static void spawnLandingParticle(LivingEntity user, float fallFactor) {
        if (!user.m_9236_().m_5776_()) {
            int x = Mth.m_14107_((double)user.m_20185_());
            int y = Mth.m_14107_((double)(user.m_20186_() - 0.5));
            int z = Mth.m_14107_((double)user.m_20189_());
            BlockPos pos = new BlockPos(x, y, z);
            BlockState state = user.m_9236_().m_8055_(pos);
            float f = Mth.m_14167_((float)fallFactor);
            if (!state.m_60795_()) {
                double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
                int i = (int)(150.0 * d0);
                if (!state.addLandingEffects((ServerLevel)user.m_9236_(), pos, state, user, i)) {
                    ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), user.m_20185_(), user.m_20186_(), user.m_20189_(), i, 0.0, 0.0, 0.0, (double)0.15f);
                }
            }
        }
    }

    public static void spawnLandingParticle(Entity user, Vec3 targetPos, Vec3 normal, float fallFactor) {
        if (!user.m_9236_().m_5776_()) {
            Vec3 blockPos = targetPos.m_82549_(normal.m_82541_().m_82490_(0.5));
            int x = Mth.m_14107_((double)blockPos.m_7096_());
            int y = Mth.m_14107_((double)blockPos.m_7098_());
            int z = Mth.m_14107_((double)blockPos.m_7094_());
            BlockPos pos = new BlockPos(x, y, z);
            BlockState state = user.m_9236_().m_8055_(pos);
            float f = Mth.m_14167_((float)fallFactor);
            if (!state.m_60795_()) {
                double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
                int i = (int)(150.0 * d0);
                ((ServerLevel)user.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_(), i, 0.0, 0.0, 0.0, (double)0.15f);
            }
        }
    }

    public static void fallDecrease(LivingEntity user) {
        if (!user.m_20068_() && !user.m_20096_()) {
            user.f_19789_ = 1.0f;
            float currentRatio = user.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
                float decRatio = state.getFallDecreaseRate();
                float newDecRatio = decRatio + 0.05f;
                newDecRatio = Math.min(1.0f, newDecRatio);
                state.setFallDecreaseRate(newDecRatio);
                return Float.valueOf(decRatio);
            }).orElse(Float.valueOf(1.0f)).floatValue();
            double gravityReductionFactor = 0.85f;
            int level = user.m_21205_().getEnchantmentLevel(Enchantments.f_44967_);
            if (level > 0) {
                gravityReductionFactor = Math.min(0.93, gravityReductionFactor + 0.02 * (double)level);
                AdvancementHelper.grantedIf(Enchantments.f_44967_, user);
            }
            AttributeInstance gravity = user.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            double g = 0.0;
            if (gravity != null) {
                g = gravity.m_22135_() * gravityReductionFactor;
            }
            Vec3 motion = user.m_20184_();
            if (motion.f_82480_ < 0.0) {
                user.m_20334_(motion.f_82479_, (motion.f_82480_ + g) * (double)currentRatio, motion.f_82481_);
            }
        }
    }

    public static void fallResist(LivingEntity user) {
        if (!user.m_20068_() && !user.m_20096_()) {
            user.f_19789_ = 1.0f;
            Vec3 motion = user.m_20184_();
            AttributeInstance gravity = user.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            double g = 0.0;
            if (gravity != null) {
                g = gravity.m_22135_();
            }
            if (motion.f_82480_ < 0.0) {
                user.m_20334_(motion.f_82479_, motion.f_82480_ + g + (double)0.002f, motion.f_82481_);
            }
        }
    }

    private static final class SingletonHolder {
        private static final FallHandler instance = new FallHandler();

        private SingletonHolder() {
        }
    }
}

