/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.inputstate.IInputState;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.NamedBladeStateCapabilityProvider;
import mods.flammpfeil.slashblade.client.renderer.SlashBladeTEISR;
import mods.flammpfeil.slashblade.data.tag.SlashBladeItemTags;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.item.ReachModifier;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashBladeItems;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.registry.specialeffects.SpecialEffect;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ItemSlashBlade
extends SwordItem {
    protected static final UUID ATTACK_DAMAGE_AMPLIFIER = UUID.fromString("2D988C13-595B-4E58-B254-39BB6FA077FD");
    protected static final UUID PLAYER_REACH_AMPLIFIER = UUID.fromString("2D988C13-595B-4E58-B254-39BB6FA077FE");
    public static final Capability<ISlashBladeState> BLADESTATE = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISlashBladeState>(){});
    public static final Capability<IInputState> INPUT_STATE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IInputState>(){});
    public static final List<Enchantment> exEnchantment = List.of(Enchantments.f_44976_, Enchantments.f_44988_, Enchantments.f_44967_, Enchantments.f_44966_, (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("minecraft", "feather_falling")), (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("minecraft", "fire_protection")), Enchantments.f_44972_);
    public static final String BREAK_ACTION_TIMEOUT = "BreakActionTimeout";
    RangeMap<Comparable<?>, Object> refineColor = ImmutableRangeMap.builder().put(Range.lessThan((Comparable)Integer.valueOf(10)), (Object)ChatFormatting.GRAY).put(Range.closedOpen((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(50)), (Object)ChatFormatting.YELLOW).put(Range.closedOpen((Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(100)), (Object)ChatFormatting.GREEN).put(Range.closedOpen((Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(150)), (Object)ChatFormatting.AQUA).put(Range.closedOpen((Comparable)Integer.valueOf(150), (Comparable)Integer.valueOf(200)), (Object)ChatFormatting.BLUE).put(Range.atLeast((Comparable)Integer.valueOf(200)), (Object)ChatFormatting.LIGHT_PURPLE).build();

    public ItemSlashBlade(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (exEnchantment.contains(enchantment)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public String getCreatorModId(ItemStack itemStack) {
        return this.getBladeId(itemStack).m_135827_();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap def = super.getAttributeModifiers(slot, stack);
        ArrayListMultimap result = ArrayListMultimap.create();
        result.putAll((Object)Attributes.f_22281_, (Iterable)def.get((Object)Attributes.f_22281_));
        result.putAll((Object)Attributes.f_22283_, (Iterable)def.get((Object)Attributes.f_22283_));
        if (slot == EquipmentSlot.MAINHAND) {
            LazyOptional state = stack.getCapability(BLADESTATE);
            state.ifPresent(arg_0 -> ItemSlashBlade.lambda$getAttributeModifiers$0(stack, (Multimap)result, arg_0));
        }
        return result;
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack stack) {
        EnumSet<SwordType> type = SwordType.from(stack);
        if (type.contains((Object)SwordType.BEWITCHED)) {
            return Rarity.EPIC;
        }
        if (type.contains((Object)SwordType.ENCHANTED)) {
            return Rarity.RARE;
        }
        return Rarity.COMMON;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (handIn == InteractionHand.OFF_HAND && !(playerIn.m_21205_().m_41720_() instanceof ItemSlashBlade)) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        boolean result = itemstack.getCapability(BLADESTATE).map(state -> {
            playerIn.getCapability(INPUT_STATE).ifPresent(s -> s.getCommands().add(InputCommand.R_CLICK));
            ResourceLocation combo = state.progressCombo((LivingEntity)playerIn);
            playerIn.getCapability(INPUT_STATE).ifPresent(s -> s.getCommands().remove((Object)InputCommand.R_CLICK));
            if (!combo.equals((Object)ComboStateRegistry.NONE.getId())) {
                playerIn.m_6674_(handIn);
            }
            return true;
        }).orElse(false);
        playerIn.m_6672_(handIn);
        return new InteractionResultHolder(result ? InteractionResult.SUCCESS : InteractionResult.FAIL, (Object)itemstack);
    }

    public boolean onLeftClickEntity(ItemStack itemstack, Player playerIn, Entity entity) {
        Optional stateHolder = itemstack.getCapability(BLADESTATE).filter(state -> !state.onClick());
        stateHolder.ifPresent(state -> {
            playerIn.getCapability(INPUT_STATE).ifPresent(s -> s.getCommands().add(InputCommand.L_CLICK));
            state.progressCombo((LivingEntity)playerIn);
            playerIn.getCapability(INPUT_STATE).ifPresent(s -> s.getCommands().remove((Object)InputCommand.L_CLICK));
        });
        return stateHolder.isPresent();
    }

    public void setDamage(ItemStack stack, int damage) {
        int maxDamage = stack.m_41776_();
        if (maxDamage < 0) {
            return;
        }
        ISlashBladeState state = (ISlashBladeState)stack.getCapability(BLADESTATE).orElseThrow(NullPointerException::new);
        if (state.isBroken()) {
            if (damage <= 0 && !state.isSealed()) {
                state.setBroken(false);
            } else if (maxDamage < damage) {
                damage = Math.min(damage, maxDamage - 1);
            }
        }
        state.setDamage(damage);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        if (stack.m_41776_() <= 0) {
            return 0;
        }
        if (amount <= 0) {
            return 0;
        }
        ISlashBladeState cap = (ISlashBladeState)stack.getCapability(BLADESTATE).orElseThrow(NullPointerException::new);
        boolean current = cap.isBroken();
        if (stack.m_41773_() + amount >= stack.m_41776_()) {
            amount = 0;
            stack.m_41721_(stack.m_41776_() - 1);
            cap.setBroken(!MinecraftForge.EVENT_BUS.post((Event)new SlashBladeEvent.BreakEvent(stack, cap)));
        }
        if (current != cap.isBroken()) {
            ServerPlayer player;
            onBroken.accept(entity);
            if (entity instanceof ServerPlayer) {
                player = (ServerPlayer)entity;
                stack.getShareTag();
                CriteriaTriggers.f_10592_.m_23682_(player, stack);
            }
            if (entity instanceof Player) {
                player = (Player)entity;
                player.m_36246_(Stats.f_12983_.m_12902_((Object)stack.m_41720_()));
            }
        }
        if (cap.isBroken() && this.isDestructable(stack)) {
            stack.m_41774_(1);
        }
        return amount;
    }

    public static Consumer<LivingEntity> getOnBroken(ItemStack stack) {
        return user -> {
            user.m_21190_(user.m_7655_());
            ISlashBladeState state = (ISlashBladeState)stack.getCapability(BLADESTATE).orElseThrow(NullPointerException::new);
            if (stack.m_41793_()) {
                int count = state.getProudSoulCount() >= (Integer)SlashBladeConfig.MAX_ENCHANTED_PROUDSOUL_DROP.get() * 100 ? (Integer)SlashBladeConfig.MAX_ENCHANTED_PROUDSOUL_DROP.get() : Math.max(1, state.getProudSoulCount() / 100);
                List<Enchantment> enchantments = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(arg_0 -> ((ItemStack)stack).canApplyAtEnchantingTable(arg_0)).filter(enchantment -> !((List)SlashBladeConfig.NON_DROPPABLE_ENCHANTMENT.get()).contains(Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.getKey(enchantment)).toString())).toList();
                for (int i = 0; i < count; ++i) {
                    ItemStack enchanted_soul = new ItemStack((ItemLike)SlashBladeItems.PROUDSOUL_TINY.get());
                    Enchantment enchant = enchantments.get(user.m_217043_().m_216339_(0, enchantments.size()));
                    if (enchant != null) {
                        enchanted_soul.m_41663_(enchant, 1);
                        ItemEntity itemEntity = new ItemEntity(user.m_9236_(), user.m_20185_(), user.m_20186_(), user.m_20189_(), enchanted_soul);
                        itemEntity.m_32060_();
                        user.m_9236_().m_7967_((Entity)itemEntity);
                    }
                    state.setProudSoulCount(state.getProudSoulCount() - 100);
                }
            }
            ItemStack soul = new ItemStack((ItemLike)SlashBladeItems.PROUDSOUL_TINY.get());
            int count = state.getProudSoulCount() >= (Integer)SlashBladeConfig.MAX_PROUDSOUL_DROP.get() * 100 ? (Integer)SlashBladeConfig.MAX_PROUDSOUL_DROP.get() : Math.max(1, state.getProudSoulCount() / 100);
            soul.m_41764_(count);
            state.setProudSoulCount(state.getProudSoulCount() - count * 100);
            ItemEntity itementity = new ItemEntity(user.m_9236_(), user.m_20185_(), user.m_20186_(), user.m_20189_(), soul);
            BladeItemEntity e = new BladeItemEntity((EntityType)SlashBlade.RegistryEvents.BladeItem, user.m_9236_()){
                static final String isReleased = "isReleased";

                @Override
                public boolean m_142535_(float distance, float damageMultiplier, @NotNull DamageSource ds) {
                    CompoundTag tag = this.getPersistentData();
                    if (!tag.m_128471_(isReleased)) {
                        Entity thrower;
                        this.getPersistentData().m_128379_(isReleased, true);
                        if (this.m_9236_() instanceof ServerLevel && (thrower = this.m_19749_()) != null) {
                            thrower.getPersistentData().m_128473_(ItemSlashBlade.BREAK_ACTION_TIMEOUT);
                        }
                    }
                    return super.m_142535_(distance, damageMultiplier, ds);
                }
            };
            e.m_20361_((Entity)itementity);
            e.init();
            e.m_5997_(0.0, 0.4, 0.0);
            e.setModel(state.getModel().orElse(DefaultResources.resourceDefaultModel));
            e.setTexture(state.getTexture().orElse(DefaultResources.resourceDefaultTexture));
            e.m_32010_(40);
            e.m_146915_(true);
            e.m_20301_(-1);
            e.m_32052_(user.m_20148_());
            user.m_9236_().m_7967_((Entity)e);
            user.getPersistentData().m_128356_(BREAK_ACTION_TIMEOUT, user.m_9236_().m_46467_() + 100L);
        };
    }

    public boolean m_7579_(ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        stack.getCapability(BLADESTATE).ifPresent(state -> {
            ComboState cs;
            ResourceLocation loc = state.resolvCurrentComboState(attacker);
            ComboState comboState = cs = ComboStateRegistry.REGISTRY.get().getValue(loc) != null ? (ComboState)ComboStateRegistry.REGISTRY.get().getValue(loc) : (ComboState)ComboStateRegistry.NONE.get();
            if (MinecraftForge.EVENT_BUS.post((Event)new SlashBladeEvent.HitEvent(stack, (ISlashBladeState)state, target, attacker))) {
                return;
            }
            if (cs != null) {
                cs.hitEffect(target, attacker);
            }
            stack.m_41622_(1, attacker, ItemSlashBlade.getOnBroken(stack));
        });
        return true;
    }

    public boolean m_6813_(@NotNull ItemStack stack, @NotNull Level worldIn, BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entityLiving) {
        if (state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            stack.getCapability(BLADESTATE).ifPresent(s -> stack.m_41622_(1, entityLiving, ItemSlashBlade.getOnBroken(stack)));
        }
        return true;
    }

    public void m_5551_(@NotNull ItemStack stack, Level worldIn, @NotNull LivingEntity entityLiving, int timeLeft) {
        int elapsed = this.m_8105_(stack) - timeLeft;
        if (!worldIn.m_5776_()) {
            stack.getCapability(BLADESTATE).ifPresent(state -> {
                EnumSet<SwordType> swordType = SwordType.from(stack);
                if (state.isBroken() || state.isSealed() || !swordType.contains((Object)SwordType.ENCHANTED)) {
                    return;
                }
                ResourceLocation sa = state.doChargeAction(entityLiving, elapsed);
                boolean isCreative = false;
                if (!sa.equals((Object)ComboStateRegistry.NONE.getId())) {
                    if (entityLiving instanceof Player) {
                        Player player = (Player)entityLiving;
                        isCreative = player.m_150110_().f_35937_;
                    }
                    if (!isCreative) {
                        int cost = state.getSlashArts().getProudSoulCost();
                        if (state.getProudSoulCount() >= cost) {
                            state.setProudSoulCount(state.getProudSoulCount() - cost);
                        } else {
                            stack.m_41622_(1, entityLiving, ItemSlashBlade.getOnBroken(stack));
                        }
                    }
                    entityLiving.m_6674_(InteractionHand.MAIN_HAND);
                }
            });
        }
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity player, ItemStack stack, int count) {
        stack.getCapability(BLADESTATE).ifPresent(state -> {
            (ComboStateRegistry.REGISTRY.get().getValue(state.getComboSeq()) != null ? (ComboState)ComboStateRegistry.REGISTRY.get().getValue(state.getComboSeq()) : (ComboState)ComboStateRegistry.NONE.get()).holdAction(player);
            EnumSet<SwordType> swordType = SwordType.from(stack);
            if (state.isBroken() || state.isSealed() || !swordType.contains((Object)SwordType.ENCHANTED)) {
                return;
            }
            if (!player.m_9236_().m_5776_()) {
                int ticks = player.m_21252_();
                int fullChargeTicks = state.getFullChargeTicks(player);
                if (0 < ticks && ticks == fullChargeTicks) {
                    Vec3 pos = player.m_20299_(1.0f).m_82549_(player.m_20154_());
                    ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 7, 0.7, 0.7, 0.7, 0.02);
                }
            }
        });
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        stack.getCapability(BLADESTATE).ifPresent(state -> {
            if (MinecraftForge.EVENT_BUS.post((Event)new SlashBladeEvent.UpdateEvent(stack, (ISlashBladeState)state, worldIn, entityIn, itemSlot, isSelected))) {
                return;
            }
            if (!isSelected) {
                EnumSet<SwordType> swordType = SwordType.from(stack);
                if (entityIn instanceof Player) {
                    boolean hasHunger;
                    Player player = (Player)entityIn;
                    if (!((Boolean)SlashBladeConfig.SELF_REPAIR_ENABLE.get()).booleanValue()) {
                        return;
                    }
                    boolean bl = hasHunger = player.m_21023_(MobEffects.f_19612_) && (Boolean)SlashBladeConfig.HUNGER_CAN_REPAIR.get() != false;
                    if ((swordType.contains((Object)SwordType.BEWITCHED) || hasHunger) && stack.m_41773_() > 0 && player.m_36324_().m_38702_() > 0) {
                        int hungerAmplifier = hasHunger ? player.m_21124_(MobEffects.f_19612_).m_19564_() : 0;
                        int level = 1 + hungerAmplifier;
                        Boolean expCostFlag = (Boolean)SlashBladeConfig.SELF_REPAIR_COST_EXP.get();
                        int expCost = (Integer)SlashBladeConfig.BEWITCHED_EXP_COST.get() * level;
                        if (expCostFlag.booleanValue() && player.f_36078_ < expCost) {
                            return;
                        }
                        player.m_6756_(expCostFlag != false ? -expCost : 0);
                        player.m_36399_(((Double)SlashBladeConfig.BEWITCHED_HUNGER_EXHAUSTION.get()).floatValue() * (float)level);
                        stack.m_41721_(stack.m_41773_() - level);
                    }
                }
            }
            if (entityIn instanceof LivingEntity) {
                ComboState cs;
                LivingEntity living = (LivingEntity)entityIn;
                entityIn.getCapability(INPUT_STATE).ifPresent(mInput -> mInput.getScheduler().onTick(living));
                ResourceLocation loc = state.resolvCurrentComboState(living);
                ComboState comboState = cs = ComboStateRegistry.REGISTRY.get().getValue(loc) != null ? (ComboState)ComboStateRegistry.REGISTRY.get().getValue(loc) : (ComboState)ComboStateRegistry.NONE.get();
                if (ItemSlashBlade.isInMainhand(stack, isSelected, living)) {
                    if (cs != null) {
                        cs.tickAction(living);
                    } else if (!loc.equals((Object)state.getComboRoot())) {
                        state.setComboSeq(state.getComboRoot());
                    }
                }
            }
        });
    }

    public static boolean isInMainhand(ItemStack stack, boolean isSelected, LivingEntity living) {
        return isSelected && stack.equals(living.m_21205_(), false);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        stack.getCapability(BLADESTATE).ifPresent(state -> {
            if (!state.isEmpty()) {
                tag.m_128365_("bladeState", (Tag)state.serializeNBT());
            }
        });
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null && nbt.m_128441_("bladeState")) {
            stack.getCapability(BLADESTATE).ifPresent(state -> state.deserializeNBT(nbt.m_128469_("bladeState")));
        }
        super.readShareTag(stack, nbt);
    }

    public int getDamage(ItemStack stack) {
        return stack.getCapability(BLADESTATE).filter(s -> !s.isEmpty()).map(ISlashBladeState::getDamage).orElse(0);
    }

    public int getMaxDamage(ItemStack stack) {
        return stack.getCapability(BLADESTATE).filter(s -> !s.isEmpty()).map(ISlashBladeState::getMaxDamage).orElse(this.m_43314_().m_6609_());
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return false;
    }

    @NotNull
    public String m_5671_(ItemStack stack) {
        return stack.getCapability(BLADESTATE).filter(s -> !s.getTranslationKey().isBlank()).map(ISlashBladeState::getTranslationKey).orElseGet(() -> this.stackDefaultDescriptionId(stack));
    }

    public ResourceLocation getBladeId(ItemStack stack) {
        return stack.getCapability(BLADESTATE).filter(s -> !s.getTranslationKey().isBlank()).map(state -> ItemSlashBlade.parseBladeID(state.getTranslationKey())).orElseGet(() -> this.stackDefaultId(stack));
    }

    private String stackDefaultDescriptionId(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("bladeState")) {
            return super.m_5671_(stack);
        }
        String key = tag.m_128469_("bladeState").m_128461_("translationKey");
        return !key.isBlank() ? key : super.m_5671_(stack);
    }

    private ResourceLocation stackDefaultId(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("bladeState")) {
            return ForgeRegistries.ITEMS.getKey((Object)this);
        }
        String key = tag.m_128469_("bladeState").m_128461_("translationKey");
        return !key.isBlank() ? ItemSlashBlade.parseBladeID(key) : ForgeRegistries.ITEMS.getKey((Object)this);
    }

    public static ResourceLocation parseBladeID(String key) {
        return ResourceLocation.m_135820_((String)key.substring(5).replaceFirst("\\.", ":"));
    }

    public boolean isDestructable(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        if (Ingredient.m_204132_((TagKey)ItemTags.f_13165_).test(repair)) {
            return true;
        }
        if (repair.m_204117_(SlashBladeItemTags.PROUD_SOULS)) {
            return true;
        }
        return super.m_6832_(toRepair, repair);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        stack.getCapability(BLADESTATE).ifPresent(s -> {
            this.appendSwordType(stack, worldIn, tooltip, flagIn);
            this.appendProudSoulCount(tooltip, stack);
            this.appendKillCount(tooltip, stack);
            this.appendSlashArt(stack, tooltip, (ISlashBladeState)s);
            this.appendRefineCount(tooltip, stack);
            this.appendSpecialEffects(tooltip, (ISlashBladeState)s);
        });
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendSlashArt(ItemStack stack, List<Component> tooltip, @NotNull ISlashBladeState s) {
        EnumSet<SwordType> swordType = SwordType.from(stack);
        if (swordType.contains((Object)SwordType.BEWITCHED) && !swordType.contains((Object)SwordType.SEALED)) {
            tooltip.add((Component)Component.m_237110_((String)"slashblade.tooltip.slash_art", (Object[])new Object[]{s.getSlashArts().getDescription()}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendRefineCount(List<Component> tooltip, @NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("bladeState")) {
            return;
        }
        int refine = tag.m_128469_("bladeState").m_128451_("RepairCounter");
        if (refine > 0) {
            tooltip.add((Component)Component.m_237110_((String)"slashblade.tooltip.refine", (Object[])new Object[]{refine}).m_130940_((ChatFormatting)this.refineColor.get((Comparable)Integer.valueOf(refine))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendProudSoulCount(List<Component> tooltip, @NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("bladeState")) {
            return;
        }
        int proudsoul = tag.m_128469_("bladeState").m_128451_("proudSoul");
        if (proudsoul > 0) {
            MutableComponent countComponent = Component.m_237110_((String)"slashblade.tooltip.proud_soul", (Object[])new Object[]{proudsoul}).m_130940_(ChatFormatting.GRAY);
            if (proudsoul > 10000) {
                countComponent = countComponent.m_130940_(ChatFormatting.DARK_PURPLE);
            }
            tooltip.add((Component)countComponent);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendKillCount(List<Component> tooltip, @NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("bladeState")) {
            return;
        }
        int killCount = tag.m_128469_("bladeState").m_128451_("killCount");
        if (killCount > 0) {
            MutableComponent killCountComponent = Component.m_237110_((String)"slashblade.tooltip.killcount", (Object[])new Object[]{killCount}).m_130940_(ChatFormatting.GRAY);
            if (killCount > 1000) {
                killCountComponent = killCountComponent.m_130940_(ChatFormatting.DARK_PURPLE);
            }
            tooltip.add((Component)killCountComponent);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendSpecialEffects(List<Component> tooltip, @NotNull ISlashBladeState s) {
        if (s.getSpecialEffects().isEmpty()) {
            return;
        }
        Minecraft mcinstance = Minecraft.m_91087_();
        LocalPlayer player = mcinstance.f_91074_;
        s.getSpecialEffects().forEach(arg_0 -> ItemSlashBlade.lambda$appendSpecialEffects$26((Player)player, tooltip, arg_0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendSwordType(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        EnumSet<SwordType> swordType = SwordType.from(stack);
        boolean goldenFlag = swordType.containsAll(List.of(SwordType.SOULEATER, SwordType.FIERCEREDGE));
        if (swordType.contains((Object)SwordType.SEALED)) {
            return;
        }
        if (swordType.contains((Object)SwordType.BEWITCHED)) {
            tooltip.add((Component)Component.m_237115_((String)"slashblade.sword_type.bewitched").m_130940_(goldenFlag ? ChatFormatting.GOLD : ChatFormatting.DARK_PURPLE));
        } else if (swordType.contains((Object)SwordType.ENCHANTED)) {
            tooltip.add((Component)Component.m_237115_((String)"slashblade.sword_type.enchanted").m_130940_(ChatFormatting.DARK_AQUA));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"slashblade.sword_type.noname").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemSlashBlade) {
            return new NamedBladeStateCapabilityProvider(stack);
        }
        return null;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return stack.getCapability(BLADESTATE).filter(s -> s.getLastActionTime() == entity.m_9236_().m_46467_()).isEmpty();
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!(entity instanceof BladeItemEntity)) {
            Level world = entity.m_9236_();
            BladeItemEntity e = new BladeItemEntity(SlashBlade.RegistryEvents.BladeItem, world);
            e.m_20361_((Entity)entity);
            e.init();
            entity.m_146870_();
            world.m_7967_((Entity)e);
        }
        return false;
    }

    public int getEntityLifespan(ItemStack itemStack, Level world) {
        return super.getEntityLifespan(itemStack, world);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            final BlockEntityWithoutLevelRenderer renderer = new SlashBladeTEISR(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
        super.initializeClient(consumer);
    }

    private static /* synthetic */ void lambda$appendSpecialEffects$26(Player player, List tooltip, ResourceLocation se) {
        boolean showingLevel;
        boolean bl = showingLevel = SpecialEffect.getRequestLevel(se) > 0;
        if (player != null) {
            tooltip.add(Component.m_237110_((String)"slashblade.tooltip.special_effect", (Object[])new Object[]{SpecialEffect.getDescription(se), Component.m_237113_((String)(showingLevel ? String.valueOf(SpecialEffect.getRequestLevel(se)) : "")).m_130940_(SpecialEffect.isEffective(se, player.f_36078_) ? ChatFormatting.RED : ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(ItemStack stack, Multimap result, ISlashBladeState s) {
        float attackAmplifier;
        EnumSet<SwordType> swordType = SwordType.from(stack);
        float baseAttackModifier = s.getBaseAttackModifier();
        int refine = s.getRefine();
        s.getAttackAmplifier();
        if (s.isBroken()) {
            attackAmplifier = -0.5f - baseAttackModifier;
        } else {
            float refineFactor = swordType.contains((Object)SwordType.FIERCEREDGE) ? 0.1f : 0.05f;
            attackAmplifier = (1.0f - 1.0f / (1.0f + refineFactor * (float)refine)) * baseAttackModifier;
        }
        double damage = (double)baseAttackModifier + (double)attackAmplifier - 1.0;
        SlashBladeEvent.UpdateAttackEvent event = new SlashBladeEvent.UpdateAttackEvent(stack, s, damage);
        MinecraftForge.EVENT_BUS.post((Event)event);
        AttributeModifier attack = new AttributeModifier(f_41374_, "Weapon modifier", event.getNewDamage(), AttributeModifier.Operation.ADDITION);
        result.remove((Object)Attributes.f_22281_, (Object)attack);
        result.put((Object)Attributes.f_22281_, (Object)attack);
        result.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(PLAYER_REACH_AMPLIFIER, "Reach amplifer", s.isBroken() ? ReachModifier.BrokendReach() : ReachModifier.BladeReach(), AttributeModifier.Operation.ADDITION));
    }
}

