/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.item;

import com.mojang.serialization.Codec;
import java.util.EnumSet;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBladeDetune;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public enum SwordType {
    NONE,
    EDGEFRAGMENT,
    BROKEN,
    ENCHANTED,
    BEWITCHED,
    FIERCEREDGE,
    NOSCABBARD,
    SEALED,
    UNBREAKABLE,
    SOULEATER;

    public static final Codec<SwordType> CODEC;

    public static EnumSet<SwordType> from(ItemStack itemStackIn) {
        EnumSet<SwordType> types = EnumSet.noneOf(SwordType.class);
        LazyOptional state = itemStackIn.getCapability(ItemSlashBlade.BLADESTATE);
        if (state.isPresent()) {
            itemStackIn.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> {
                if (s.isBroken() || SwordType.getElement(itemStackIn).m_128471_("isBroken")) {
                    types.add(BROKEN);
                }
                if (s.isSealed() || SwordType.getElement(itemStackIn).m_128471_("isSealed")) {
                    types.add(SEALED);
                }
                if (!s.isSealed() && itemStackIn.m_41793_() && (itemStackIn.m_41788_() || s.isDefaultBewitched())) {
                    types.add(BEWITCHED);
                }
                if (s.getKillCount() >= 1000) {
                    types.add(FIERCEREDGE);
                }
                if (s.getProudSoulCount() >= 10000) {
                    types.add(SOULEATER);
                }
            });
        } else {
            types.add(NOSCABBARD);
            types.add(EDGEFRAGMENT);
        }
        if (itemStackIn.m_41793_()) {
            types.add(ENCHANTED);
        }
        if (itemStackIn.m_41720_() instanceof ItemSlashBladeDetune) {
            types.remove((Object)ENCHANTED);
            types.remove((Object)BEWITCHED);
        }
        if (itemStackIn.m_41784_().m_128471_("Unbreakable")) {
            types.remove((Object)BROKEN);
        }
        return types;
    }

    private static CompoundTag getElement(ItemStack itemStackIn) {
        if (itemStackIn.m_41784_().m_128441_("bladeState")) {
            return itemStackIn.m_41737_("bladeState");
        }
        return new CompoundTag();
    }

    static {
        CODEC = Codec.STRING.xmap(string -> SwordType.valueOf(string.toUpperCase()), instance -> instance.name().toLowerCase());
    }
}

