/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.slashblade.EnchantmentDefinition;
import net.minecraft.Util;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public record RequestDefinition(ResourceLocation name, int proudSoulCount, int killCount, int refineCount, List<EnchantmentDefinition> enchantments, List<SwordType> defaultType) {
    public static final Codec<RequestDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.optionalFieldOf("name", (Object)SlashBlade.prefix("none")).forGetter(RequestDefinition::name), (App)Codec.INT.optionalFieldOf("proud_soul", (Object)0).forGetter(RequestDefinition::proudSoulCount), (App)Codec.INT.optionalFieldOf("kill", (Object)0).forGetter(RequestDefinition::killCount), (App)Codec.INT.optionalFieldOf("refine", (Object)0).forGetter(RequestDefinition::refineCount), (App)EnchantmentDefinition.CODEC.listOf().optionalFieldOf("enchantments", (Object)Lists.newArrayList()).forGetter(RequestDefinition::enchantments), (App)SwordType.CODEC.listOf().optionalFieldOf("sword_type", (Object)Lists.newArrayList()).forGetter(RequestDefinition::defaultType)).apply((Applicative)instance, RequestDefinition::new));

    public static RequestDefinition fromJSON(JsonObject json) {
        return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(msg -> SlashBlade.LOGGER.error("Failed to parse : {}", msg)).orElseGet(Builder.newInstance()::build);
    }

    public JsonElement toJson() {
        return (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).resultOrPartial(msg -> SlashBlade.LOGGER.error("Failed to encode : {}", msg)).orElseThrow();
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.name());
        buffer.writeInt(this.proudSoulCount());
        buffer.writeInt(this.killCount());
        buffer.writeInt(this.refineCount());
        buffer.m_236828_(this.enchantments(), (buf, request) -> {
            buf.m_130085_(request.getEnchantmentID());
            buf.writeByte(request.getEnchantmentLevel());
        });
        buffer.m_236828_(this.defaultType(), (buf, request) -> buf.m_130070_(request.name().toLowerCase()));
    }

    public static RequestDefinition fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation name = buffer.m_130281_();
        int proud = buffer.readInt();
        int kill = buffer.readInt();
        int refine = buffer.readInt();
        List enchantments = buffer.m_236845_(buf -> new EnchantmentDefinition(buf.m_130281_(), buf.readByte()));
        List types = buffer.m_236845_(buf -> SwordType.valueOf(buf.m_130277_().toUpperCase()));
        return new RequestDefinition(name, proud, kill, refine, enchantments, types);
    }

    public void initItemStack(ItemStack blade) {
        ISlashBladeState state = (ISlashBladeState)blade.getCapability(ItemSlashBlade.BLADESTATE).orElse((Object)new SlashBladeState(blade));
        state.setNonEmpty();
        if (!this.name.equals((Object)SlashBlade.prefix("none"))) {
            state.setTranslationKey(this.getTranslationKey());
        }
        state.setProudSoulCount(this.proudSoulCount());
        state.setKillCount(this.killCount());
        state.setRefine(this.refineCount());
        this.enchantments().forEach(enchantment -> blade.m_41663_((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantment.getEnchantmentID()), enchantment.getEnchantmentLevel()));
        this.defaultType.forEach(type -> {
            switch (type) {
                case BEWITCHED: {
                    state.setDefaultBewitched(true);
                    break;
                }
                case BROKEN: {
                    blade.m_41721_(blade.m_41776_() - 1);
                    state.setBroken(true);
                    break;
                }
                case SEALED: {
                    state.setSealed(true);
                    break;
                }
            }
        });
        blade.m_41784_().m_128365_("bladeState", (Tag)state.serializeNBT());
    }

    public boolean test(ItemStack blade) {
        if (blade == null || blade.m_41619_()) {
            return false;
        }
        if (!blade.getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            return false;
        }
        ISlashBladeState state = (ISlashBladeState)blade.getCapability(ItemSlashBlade.BLADESTATE).orElseThrow(NullPointerException::new);
        boolean nameCheck = this.name.equals((Object)SlashBlade.prefix("none")) ? state.getTranslationKey().isBlank() : state.getTranslationKey().equals(this.getTranslationKey());
        boolean proudCheck = state.getProudSoulCount() >= this.proudSoulCount();
        boolean killCheck = state.getKillCount() >= this.killCount();
        boolean refineCheck = state.getRefine() >= this.refineCount();
        for (EnchantmentDefinition enchantment : this.enchantments()) {
            if (blade.getEnchantmentLevel((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantment.getEnchantmentID())) >= enchantment.getEnchantmentLevel()) continue;
            return false;
        }
        boolean types = SwordType.from(blade).containsAll(this.defaultType());
        return nameCheck && proudCheck && killCheck && refineCheck && types;
    }

    public String getTranslationKey() {
        return Util.m_137492_((String)"item", (ResourceLocation)this.name());
    }

    public static class Builder {
        private ResourceLocation name = SlashBlade.prefix("none");
        private int proudCount = 0;
        private int killCount = 0;
        private int refineCount = 0;
        private final List<EnchantmentDefinition> enchantments = new ArrayList<EnchantmentDefinition>();
        private final List<SwordType> defaultType = new ArrayList<SwordType>();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder name(ResourceLocation name) {
            this.name = name;
            return this;
        }

        public Builder proudSoul(int proudCount) {
            this.proudCount = proudCount;
            return this;
        }

        public Builder killCount(int killCount) {
            this.killCount = killCount;
            return this;
        }

        public Builder refineCount(int refineCount) {
            this.refineCount = refineCount;
            return this;
        }

        public Builder addEnchantment(EnchantmentDefinition ... enchantments) {
            Collections.addAll(this.enchantments, enchantments);
            return this;
        }

        public Builder addSwordType(SwordType ... types) {
            Collections.addAll(this.defaultType, types);
            return this;
        }

        public RequestDefinition build() {
            return new RequestDefinition(this.name, this.proudCount, this.killCount, this.refineCount, this.enchantments, this.defaultType);
        }
    }
}

