/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.recipe.SlashBladeShapedRecipe;
import mods.flammpfeil.slashblade.registry.SlashBladeItems;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SlashBladeShapedRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category = RecipeCategory.COMBAT;
    private final Item result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    private String group;
    private boolean showNotification = true;
    private ResourceLocation blade = null;

    public SlashBladeShapedRecipeBuilder(ItemLike item, int count) {
        this.result = item.m_5456_();
        this.count = count;
    }

    public static SlashBladeShapedRecipeBuilder shaped(ResourceLocation blade) {
        return SlashBladeShapedRecipeBuilder.shaped((ItemLike)SlashBladeItems.SLASHBLADE.get(), 1).blade(blade);
    }

    public static SlashBladeShapedRecipeBuilder shaped(ItemLike result) {
        return SlashBladeShapedRecipeBuilder.shaped(result, 1);
    }

    public static SlashBladeShapedRecipeBuilder shaped(ItemLike result, int count) {
        return new SlashBladeShapedRecipeBuilder(result, count);
    }

    public SlashBladeShapedRecipeBuilder define(Character key, TagKey<Item> tag) {
        return this.define(key, Ingredient.m_204132_(tag));
    }

    public SlashBladeShapedRecipeBuilder define(Character key, ItemLike tag) {
        return this.define(key, Ingredient.m_43929_((ItemLike[])new ItemLike[]{tag}));
    }

    public SlashBladeShapedRecipeBuilder blade(ResourceLocation blade) {
        this.blade = blade;
        return this;
    }

    public SlashBladeShapedRecipeBuilder define(Character key, Ingredient ingredient) {
        if (this.key.containsKey(key)) {
            throw new IllegalArgumentException("Symbol '" + key + "' is already defined!");
        }
        if (key.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(key, ingredient);
        return this;
    }

    public SlashBladeShapedRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pattern);
        return this;
    }

    @NotNull
    public SlashBladeShapedRecipeBuilder unlockedBy(@NotNull String key, @NotNull CriterionTriggerInstance trigger) {
        this.advancement.m_138386_(key, trigger);
        return this;
    }

    @NotNull
    public SlashBladeShapedRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public SlashBladeShapedRecipeBuilder showNotification(boolean show) {
        this.showNotification = show;
        return this;
    }

    @NotNull
    public Item m_142372_() {
        return this.result;
    }

    public void m_176498_(@NotNull Consumer<FinishedRecipe> consumer) {
        this.m_126140_(consumer, this.blade != null ? this.blade : Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.m_142372_())));
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept((FinishedRecipe)new Result(id, this.result, this.count, this.blade, this.group == null ? "" : this.group, this.rows, this.key, this.advancement, id.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.showNotification));
    }

    private void ensureValid(ResourceLocation p_126144_) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + p_126144_ + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + p_126144_ + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + p_126144_);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + p_126144_ + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126144_);
        }
    }

    public static class Result
    extends CraftingRecipeBuilder.CraftingResult {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final ResourceLocation bladeId;
        private final boolean showNotification;

        public Result(ResourceLocation id, Item result, int count, ResourceLocation bladeId, String group, List<String> pattern, Map<Character, Ingredient> key, Advancement.Builder advancement, ResourceLocation advancementId, boolean showNotification) {
            super(CraftingBookCategory.EQUIPMENT);
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.bladeId = bladeId;
            this.showNotification = showNotification;
        }

        public void m_7917_(@NotNull JsonObject json) {
            super.m_7917_(json);
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            json.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            json.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result)).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
            if (this.bladeId != null) {
                json.addProperty("blade", this.bladeId.toString());
            }
            json.addProperty("show_notification", Boolean.valueOf(this.showNotification));
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return SlashBladeShapedRecipe.SERIALIZER;
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

