/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.registry.slashblade;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import net.minecraft.resources.ResourceLocation;

public class PropertiesDefinition {
    public static final Codec<PropertiesDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.optionalFieldOf("root_combo", (Object)ComboStateRegistry.STANDBY.getId()).forGetter(PropertiesDefinition::getComboRoot), (App)ResourceLocation.f_135803_.optionalFieldOf("slash_art", (Object)SlashArtsRegistry.JUDGEMENT_CUT.getId()).forGetter(PropertiesDefinition::getSpecialAttackType), (App)Codec.FLOAT.optionalFieldOf("attack_base", (Object)Float.valueOf(4.0f)).forGetter(PropertiesDefinition::getBaseAttackModifier), (App)Codec.INT.optionalFieldOf("max_damage", (Object)40).forGetter(PropertiesDefinition::getMaxDamage), (App)SwordType.CODEC.listOf().optionalFieldOf("sword_type", (Object)Lists.newArrayList()).forGetter(PropertiesDefinition::getDefaultType), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("special_effects", (Object)Lists.newArrayList()).forGetter(PropertiesDefinition::getSpecialEffects), (App)Codec.BOOL.optionalFieldOf("unbreakable", (Object)false).forGetter(PropertiesDefinition::isUnbreakable)).apply((Applicative)instance, PropertiesDefinition::new));
    private final ResourceLocation comboRoot;
    private final ResourceLocation specialAttackType;
    private final float baseAttackModifier;
    private final int maxDamage;
    private final List<SwordType> defaultType;
    private final List<ResourceLocation> specialEffects;
    private final boolean unbreakable;

    private PropertiesDefinition(ResourceLocation comboRoot, ResourceLocation specialAttackType, float baseAttackModifier, int damage, List<SwordType> defaultType, List<ResourceLocation> specialEffects, boolean unbreakable) {
        this.comboRoot = comboRoot;
        this.specialAttackType = specialAttackType;
        this.baseAttackModifier = baseAttackModifier;
        this.maxDamage = damage;
        this.defaultType = defaultType;
        this.specialEffects = specialEffects;
        this.unbreakable = unbreakable;
    }

    public List<ResourceLocation> getSpecialEffects() {
        return this.specialEffects;
    }

    public ResourceLocation getComboRoot() {
        return this.comboRoot;
    }

    public ResourceLocation getSpecialAttackType() {
        return this.specialAttackType;
    }

    public float getBaseAttackModifier() {
        return this.baseAttackModifier;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public List<SwordType> getDefaultType() {
        return this.defaultType;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public static class Builder {
        private ResourceLocation comboRoot = ComboStateRegistry.STANDBY.getId();
        private ResourceLocation specialAttackType = SlashArtsRegistry.JUDGEMENT_CUT.getId();
        private float baseAttackModifier = 4.0f;
        private int maxDamage = 40;
        private List<SwordType> defaultType = Lists.newArrayList();
        private final List<ResourceLocation> specialEffects = Lists.newArrayList();
        private boolean unbreakable = false;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder rootComboState(ResourceLocation comboRoot) {
            this.comboRoot = comboRoot;
            return this;
        }

        public Builder slashArtsType(ResourceLocation specialAttackType) {
            this.specialAttackType = specialAttackType;
            return this;
        }

        public Builder baseAttackModifier(float baseAttackModifier) {
            this.baseAttackModifier = baseAttackModifier;
            return this;
        }

        public Builder maxDamage(int maxDamage) {
            this.maxDamage = maxDamage;
            return this;
        }

        public Builder defaultSwordType(List<SwordType> defaultType) {
            this.defaultType = defaultType;
            return this;
        }

        public Builder addSpecialEffect(ResourceLocation se) {
            this.specialEffects.add(se);
            return this;
        }

        public Builder setUnbreakable(boolean unbreakable) {
            this.unbreakable = unbreakable;
            return this;
        }

        public PropertiesDefinition build() {
            return new PropertiesDefinition(this.comboRoot, this.specialAttackType, this.baseAttackModifier, this.maxDamage, this.defaultType, this.specialEffects, this.unbreakable);
        }
    }
}

