/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.concentrationrank.ConcentrationRankCapabilityProvider;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.AttackManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;

public class AttackHelper {
    public static void attack(LivingEntity attacker, Entity target, float comboRatio) {
        DamageSource damageSource;
        Player player;
        if (attacker instanceof Player && !ForgeHooks.onPlayerAttackTarget((Player)(player = (Player)attacker), (Entity)target)) {
            return;
        }
        if (!target.m_6097_() || target.m_7313_((Entity)attacker)) {
            return;
        }
        boolean isCritical = AttackHelper.isCriticalHit(attacker, target);
        double baseDamage = AttackHelper.calculateTotalDamage(attacker, target, comboRatio, isCritical);
        if (baseDamage <= 0.0) {
            return;
        }
        float knockback = AttackHelper.calculateKnockback(attacker);
        FireAspectResult fireAspectResult = AttackHelper.handleFireAspect(attacker, target);
        Vec3 originalMotion = target.m_20184_();
        if (attacker instanceof Player) {
            Player player2 = (Player)attacker;
            damageSource = attacker.m_269291_().m_269075_(player2);
        } else {
            damageSource = attacker.m_269291_().m_269333_(attacker);
        }
        boolean damageSuccess = target.m_6469_(damageSource, (float)baseDamage);
        if (damageSuccess) {
            AttackHelper.applyKnockback(attacker, target, knockback);
            AttackHelper.restoreTargetMotionIfNeeded(target, originalMotion);
            AttackHelper.playAttackEffects(attacker, target, isCritical);
            AttackHelper.handleEnchantmentsAndDurability(attacker, target);
            AttackHelper.handlePostAttackEffects(attacker, target, fireAspectResult);
        } else {
            AttackHelper.handleFailedAttack(attacker, target, fireAspectResult);
        }
    }

    public static double calculateTotalDamage(LivingEntity attacker, Entity target, float comboRatio, boolean isCritical) {
        double baseDamage = attacker.m_21133_(Attributes.f_22281_);
        baseDamage += (double)AttackHelper.getSweepingBonus(attacker);
        baseDamage += (double)AttackHelper.getRankBonus(attacker);
        baseDamage += (double)AttackHelper.getEnchantmentBonus(attacker, target);
        baseDamage *= (double)(comboRatio * AttackManager.getSlashBladeDamageScale(attacker)) * (Double)SlashBladeConfig.SLASHBLADE_DAMAGE_MULTIPLIER.get();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)player, (Entity)target, (boolean)isCritical, (float)(isCritical ? 1.5f : 1.0f));
            boolean bl = isCritical = hitResult != null;
            if (isCritical) {
                baseDamage *= (double)hitResult.getDamageModifier();
            }
        }
        return baseDamage;
    }

    public static float getSweepingBonus(LivingEntity attacker) {
        return 10.0f * (EnchantmentHelper.m_44821_((LivingEntity)attacker) * 0.5f);
    }

    public static float getRankBonus(LivingEntity attacker) {
        IConcentrationRank.ConcentrationRanks rankBonus = attacker.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).map(rp -> rp.getRank(attacker.m_20193_().m_46467_())).orElse(IConcentrationRank.ConcentrationRanks.NONE);
        double rankDamageBonus = (double)rankBonus.level / 2.0;
        if (IConcentrationRank.ConcentrationRanks.S.level <= rankBonus.level) {
            int refine = attacker.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(ISlashBladeState::getRefine).orElse(0);
            int level = 0;
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                level = player.f_36078_;
            }
            rankDamageBonus = Math.max(rankDamageBonus, (double)Math.min(level, refine) * (Double)SlashBladeConfig.REFINE_DAMAGE_MULTIPLIER.get());
        }
        return (float)rankDamageBonus;
    }

    public static float getEnchantmentBonus(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            return EnchantmentHelper.m_44833_((ItemStack)attacker.m_21205_(), (MobType)living.m_6336_());
        }
        return EnchantmentHelper.m_44833_((ItemStack)attacker.m_21205_(), (MobType)MobType.f_21640_);
    }

    public static float calculateKnockback(LivingEntity attacker) {
        float knockback = (float)attacker.m_21133_(Attributes.f_22282_);
        knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)attacker);
        if (attacker.m_20142_()) {
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12314_, attacker.m_5720_(), 1.0f, 1.0f);
            knockback += 1.0f;
        }
        return knockback;
    }

    public static boolean isCriticalHit(LivingEntity attacker, Entity target) {
        return attacker.f_19789_ > 0.0f && !attacker.m_20096_() && !attacker.m_6147_() && !attacker.m_20069_() && !attacker.m_21023_(MobEffects.f_19610_) && !attacker.m_20159_() && target instanceof LivingEntity && !attacker.m_20142_();
    }

    public static FireAspectResult handleFireAspect(LivingEntity attacker, Entity target) {
        float preAttackHealth = 0.0f;
        boolean shouldSetFire = false;
        int fireAspectLevel = EnchantmentHelper.m_44914_((LivingEntity)attacker);
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            preAttackHealth = living.m_21223_();
            if (fireAspectLevel > 0 && !target.m_6060_()) {
                shouldSetFire = true;
                target.m_20254_(1);
            }
        }
        return new FireAspectResult(preAttackHealth, shouldSetFire, fireAspectLevel);
    }

    public static void applyKnockback(LivingEntity attacker, Entity target, float knockback) {
        if (knockback > 0.0f) {
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                living.m_147240_((double)knockback * 0.5, (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
            } else {
                target.m_5997_((double)(-Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))) * knockback) * 0.5, 0.1, (double)(Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180))) * knockback) * 0.5);
            }
            attacker.m_20256_(attacker.m_20184_().m_82542_(0.6, 1.0, 0.6));
            attacker.m_6858_(false);
        }
    }

    public static void restoreTargetMotionIfNeeded(Entity target, Vec3 originalMotion) {
        if (target instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)target;
            if (target.f_19864_) {
                target.m_20256_(originalMotion);
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(target));
                target.f_19864_ = false;
            }
        }
    }

    public static void playAttackEffects(LivingEntity attacker, Entity target, boolean isCritical) {
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12313_, attacker.m_5720_(), 1.0f, 1.0f);
        if (isCritical && attacker instanceof Player) {
            Player player = (Player)attacker;
            player.m_5704_(target);
        }
    }

    public static void handleEnchantmentsAndDurability(LivingEntity attacker, Entity target) {
        attacker.m_21335_(target);
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            EnchantmentHelper.m_44823_((LivingEntity)living, (Entity)attacker);
        }
        EnchantmentHelper.m_44896_((LivingEntity)attacker, (Entity)target);
        ItemStack itemStack = attacker.m_21205_();
        Entity entity = target;
        if (target instanceof PartEntity) {
            PartEntity partEntity = (PartEntity)target;
            entity = partEntity.getParent();
        }
        if (!attacker.m_9236_().m_5776_() && !itemStack.m_41619_() && entity instanceof LivingEntity) {
            Player player;
            LivingEntity living = (LivingEntity)entity;
            ItemStack copy = itemStack.m_41777_();
            Item item = itemStack.m_41720_();
            if (item.m_7579_(itemStack, living, attacker) && attacker instanceof Player) {
                player = (Player)attacker;
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            }
            if (itemStack.m_41619_()) {
                if (attacker instanceof Player) {
                    player = (Player)attacker;
                    ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)InteractionHand.MAIN_HAND);
                }
                attacker.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
        }
    }

    public static void handlePostAttackEffects(LivingEntity attacker, Entity target, FireAspectResult fireAspectResult) {
        if (target instanceof LivingEntity) {
            float damageDealt = fireAspectResult.preAttackHealth - ((LivingEntity)target).m_21223_();
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                player.m_36222_(Stats.f_12928_, Math.round(damageDealt * 10.0f));
            }
            if (fireAspectResult.fireAspectLevel > 0) {
                target.m_20254_(fireAspectResult.fireAspectLevel * 4);
            }
            if (attacker.m_9236_() instanceof ServerLevel && damageDealt > 2.0f) {
                int k = (int)((double)damageDealt * 0.5);
                ((ServerLevel)attacker.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
            }
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            player.m_36399_(0.1f);
        }
    }

    public static void handleFailedAttack(LivingEntity attacker, Entity target, FireAspectResult fireAspectResult) {
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12315_, attacker.m_5720_(), 1.0f, 1.0f);
        if (fireAspectResult.shouldSetFire) {
            target.m_20095_();
        }
    }

    public static class FireAspectResult {
        final float preAttackHealth;
        final boolean shouldSetFire;
        final int fireAspectLevel;

        FireAspectResult(float preAttackHealth, boolean shouldSetFire, int fireAspectLevel) {
            this.preAttackHealth = preAttackHealth;
            this.shouldSetFire = shouldSetFire;
            this.fireAspectLevel = fireAspectLevel;
        }
    }
}

