/*
 * Decompiled with CFR 0.152.
 */
package net.phremic.cageriumrecaged.blockentity;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.phremic.cageriumrecaged.blockentity.util.TickableBlockEntity;
import net.phremic.cageriumrecaged.config.CageriumRecagedCommonConfigs;
import net.phremic.cageriumrecaged.init.ItemInit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FarmBlockEntity
extends BlockEntity
implements TickableBlockEntity {
    private Entity entity;
    private int tickCount;
    private static final GameProfile DUMMY_PROFILE = new GameProfile(UUID.fromString("5b580441-d54a-38f1-1120-e3842a80632b"), "[cageriumrecaged]");
    private final LazyOptional<ItemStackHandler> optional = LazyOptional.of(() -> this.inventory);
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            FarmBlockEntity.this.m_6596_();
            if (FarmBlockEntity.this.f_58857_ != null) {
                FarmBlockEntity.this.f_58857_.m_7260_(FarmBlockEntity.this.m_58899_(), FarmBlockEntity.this.m_58900_(), FarmBlockEntity.this.m_58900_(), 3);
            }
        }
    };

    public FarmBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        CompoundTag cageriumRecagedModData = pTag.m_128469_("cageriumrecaged");
        this.inventory.deserializeNBT(cageriumRecagedModData.m_128469_("Inventory"));
        this.tickCount = cageriumRecagedModData.m_128451_("TickCount");
        this.entity = this.getEntityFromStack(this.getStack());
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        CompoundTag cageriumRecagedModData = new CompoundTag();
        cageriumRecagedModData.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        cageriumRecagedModData.m_128405_("TickCount", this.tickCount);
        pTag.m_128365_("cageriumrecaged", (Tag)cageriumRecagedModData);
        this.entity = this.getEntityFromStack(this.getStack());
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.optional.cast() : super.getCapability(cap);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.optional.invalidate();
    }

    @Override
    public void tick() {
        if (this.entity != null) {
            ++this.tickCount;
            if (this.tickCount > (Integer)CageriumRecagedCommonConfigs.GENERATE_LOOT_PERIOD.get()) {
                this.tickCount = 0;
                for (int i = 0; i < (Integer)CageriumRecagedCommonConfigs.GENERATE_LOOT_INSTANCES.get(); ++i) {
                    this.generateLoot();
                }
            }
        }
    }

    public ItemStack getStack() {
        return this.inventory.getStackInSlot(0);
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Entity getEntityFromStack(ItemStack pStack) {
        if (this.f_58857_ == null) {
            return null;
        }
        if (pStack == null) {
            return null;
        }
        CompoundTag mod_id_tag = pStack.m_41737_("cageriumrecaged");
        if (mod_id_tag == null) {
            return null;
        }
        String entity_id = mod_id_tag.m_128461_("EntityID");
        Optional optional_entity_type = EntityType.m_20632_((String)entity_id);
        return optional_entity_type.map(entityType -> entityType.m_20615_(this.f_58857_)).orElse(null);
    }

    public void addSoulShard(ItemStack pStack) {
        this.tickCount = 0;
        this.entity = this.getEntityFromStack(pStack);
        this.inventory.insertItem(0, pStack, false);
    }

    public ItemStack removeSoulShard() {
        this.entity = null;
        return this.inventory.extractItem(0, this.getStack().m_41613_(), false);
    }

    private void generateLoot() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.getStack().m_41619_()) {
            return;
        }
        if (this.getStack().m_41720_() != ItemInit.FILLED_SOUL_SHARD.get()) {
            return;
        }
        CompoundTag mod_id_tag = this.getStack().m_41737_("cageriumrecaged");
        if (mod_id_tag == null) {
            return;
        }
        if (mod_id_tag.m_128461_("EntityID").isEmpty()) {
            return;
        }
        BlockEntity below_block_entity = this.f_58857_.getExistingBlockEntity(this.m_58899_().m_7495_());
        if (below_block_entity == null) {
            return;
        }
        IItemHandler item_handler = (IItemHandler)below_block_entity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).orElse((Object)null);
        NonNullList<ItemStack> drops_list = this.generateDropsList();
        drops_list.forEach(pItem -> ItemHandlerHelper.insertItem((IItemHandler)item_handler, (ItemStack)pItem, (boolean)false));
    }

    private NonNullList<ItemStack> generateDropsList() {
        NonNullList drops_list = NonNullList.m_122779_();
        if (this.entity instanceof EnderDragon) {
            drops_list.add((Object)Items.f_42104_.m_7968_());
        } else if (this.entity instanceof MagmaCube) {
            if (new Random().nextBoolean()) {
                drops_list.add((Object)Items.f_42542_.m_7968_());
            }
        } else if (this.entity instanceof Piglin) {
            Random random = new Random();
            if (random.nextFloat() < 0.0425f) {
                ItemStack item = new Random().nextBoolean() ? Items.f_42430_.m_7968_() : Items.f_42717_.m_7968_();
                item.m_41721_(new Random().nextInt(item.m_41776_()));
                drops_list.add((Object)item);
            }
            NonNullList armor_list = NonNullList.m_122779_();
            armor_list.add((Object)Items.f_42476_.m_7968_());
            armor_list.add((Object)Items.f_42477_.m_7968_());
            armor_list.add((Object)Items.f_42478_.m_7968_());
            armor_list.add((Object)Items.f_42479_.m_7968_());
            armor_list.forEach(pItem -> {
                Random random = new Random();
                if (random.nextFloat() < 0.0085f) {
                    pItem.m_41721_(new Random().nextInt(pItem.m_41776_()));
                    drops_list.add(pItem);
                }
            });
        } else if (this.entity instanceof PiglinBrute) {
            Random random = new Random();
            if (random.nextFloat() < 0.085f) {
                ItemStack item = Items.f_42433_.m_7968_();
                item.m_41721_(new Random().nextInt(item.m_41776_()));
                drops_list.add((Object)item);
            }
        } else if (this.entity instanceof WanderingTrader) {
            Random random = new Random();
            if (random.nextFloat() < 0.085f) {
                drops_list.add((Object)Items.f_42455_.m_7968_());
            }
            Random random2 = new Random();
            if (random2.nextFloat() < 0.085f) {
                drops_list.add((Object)PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)Potions.f_43605_));
            }
        } else if (this.entity instanceof WitherBoss) {
            drops_list.add((Object)Items.f_42686_.m_7968_());
        } else {
            Entity item = this.entity;
            if (item instanceof LivingEntity) {
                LivingEntity living_entity = (LivingEntity)item;
                if (this.f_58857_ == null) {
                    return drops_list;
                }
                MinecraftServer server = this.f_58857_.m_7654_();
                if (server == null) {
                    return drops_list;
                }
                LootTable loot_table = server.m_278653_().m_278676_(living_entity.m_5743_());
                FakePlayer player = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.f_58857_), (GameProfile)DUMMY_PROFILE);
                LootParams.Builder loot_params_builder = new LootParams.Builder((ServerLevel)this.f_58857_);
                loot_params_builder.m_287286_(LootContextParams.f_81455_, (Object)living_entity);
                loot_params_builder.m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_));
                loot_params_builder.m_287286_(LootContextParams.f_81457_, (Object)this.f_58857_.m_269111_().m_269264_());
                loot_params_builder.m_287286_(LootContextParams.f_81456_, (Object)player);
                LootParams loot_params = loot_params_builder.m_287235_(LootContextParamSets.f_81415_);
                if (living_entity instanceof Drowned) {
                    Random random = new Random();
                    if (random.nextFloat() < 0.0053125f) {
                        drops_list.add((Object)Items.f_42713_.m_7968_());
                    }
                    Random random3 = new Random();
                    if (random3.nextFloat() < 0.03f) {
                        drops_list.add((Object)Items.f_42715_.m_7968_());
                    }
                } else if (living_entity instanceof ZombifiedPiglin) {
                    Random random = new Random();
                    if (random.nextFloat() < 0.085f) {
                        ItemStack item2 = Items.f_42430_.m_7968_();
                        item2.m_41721_(new Random().nextInt(item2.m_41776_()));
                        drops_list.add((Object)item2);
                    }
                }
                drops_list.addAll((Collection)loot_table.m_287195_(loot_params));
            }
        }
        return drops_list;
    }
}

