/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import dev.architectury.event.events.common.PlayerEvent;
import io.github.tigercrl.gokiskills.GokiSkills;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillEvents;
import io.github.tigercrl.gokiskills.skill.SkillHelper;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import io.github.tigercrl.gokiskills.skill.Skills;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class SkillHooks {
    public static final ResourceLocation HEALTH_SKILL_MODIFIER = GokiSkills.resource("health_skill_modifier");
    public static final ResourceLocation KNOCKBACK_RESISTANCE_SKILL_MODIFIER = GokiSkills.resource("knockback_resistance_skill_modifier");
    public static final ResourceLocation NINJA_SKILL_MODIFIER = GokiSkills.resource("ninja_skill_modifier");

    public static void register() {
        PlayerEvent.PLAYER_JOIN.register(SkillHooks::updateAttributes);
        PlayerEvent.PLAYER_RESPAWN.register((player, conqueredEnd, reason) -> {
            if (reason.shouldDestroy()) {
                SkillHooks.updateAttributes(player);
                player.setHealth(player.getMaxHealth());
            }
        });
        SkillEvents.UPDATE.register((skill, player, newLevel, oldLevel, info) -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                SkillHooks.updateAttribute(sp, info, skill);
            }
        });
        SkillEvents.TOGGLE.register((skill, player, newState, info) -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                SkillHooks.updateAttribute(sp, info, skill);
            }
        });
    }

    public static void updateAttributes(ServerPlayer player) {
        SkillInfo info = SkillHelper.getInfo((Player)player);
        SkillHooks.updateAttribute(player, info, Skills.KNOCKBACK_RESISTANCE);
        SkillHooks.updateAttribute(player, info, Skills.HEALTH);
    }

    public static void updateAttribute(ServerPlayer player, SkillInfo info, ISkill skill) {
        if (skill == Skills.KNOCKBACK_RESISTANCE) {
            SkillHooks.updateAttribute(player, info, Skills.KNOCKBACK_RESISTANCE, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, KNOCKBACK_RESISTANCE_SKILL_MODIFIER, AttributeModifier.Operation.ADD_VALUE);
        } else if (skill == Skills.HEALTH) {
            SkillHooks.updateAttribute(player, info, Skills.HEALTH, (Holder<Attribute>)Attributes.MAX_HEALTH, HEALTH_SKILL_MODIFIER, AttributeModifier.Operation.ADD_VALUE);
        }
    }

    public static void updateAttribute(ServerPlayer player, SkillInfo info, ISkill skill, Holder<Attribute> attribute, ResourceLocation location, AttributeModifier.Operation operation) {
        SkillHooks.updateAttribute(player, info, skill, attribute, location, operation, true);
    }

    public static void updateAttribute(ServerPlayer player, SkillInfo info, ISkill skill, Holder<Attribute> attribute, ResourceLocation location, AttributeModifier.Operation operation, boolean condition) {
        double bonus = info.getBonus(skill);
        AttributeInstance instance = player.getAttribute(attribute);
        AttributeModifier oldModifier = instance.getModifier(location);
        if (condition && info.isEnabled(skill) && bonus > 0.0) {
            if (oldModifier == null || oldModifier.amount() != bonus) {
                instance.removeModifier(location);
                instance.addTransientModifier(new AttributeModifier(location, bonus, operation));
            }
        } else if (oldModifier != null) {
            instance.removeModifier(location);
        }
    }
}

