/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import io.github.tigercrl.gokiskills.client.gui.utils.SkillTexture;
import io.github.tigercrl.gokiskills.client.gui.utils.SkillTextures;
import io.github.tigercrl.gokiskills.misc.GokiUtils;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.Skill;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Skills {
    private static final ResourceLocation abilityCategory = new ResourceLocation("gokiskills", "1_ability");
    private static final ResourceLocation breakingCategory = new ResourceLocation("gokiskills", "3_breaking");
    private static final ResourceLocation professionCategory = new ResourceLocation("gokiskills", "2_profession");
    private static final ResourceLocation protectionCategory = new ResourceLocation("gokiskills", "4_protection");
    public static final ISkill CLIMBING = new Skill.Builder().setCategory(abilityCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.ORANGE)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/ladder.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/acacia_planks.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.climbing.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.climbing.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2)})).build();
    public static final ISkill FORTUNE = new Skill.Builder().setCategory(abilityCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.RAINBOW)).setMaxLevel(3).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("gokiskills", "textures/gui/icon/goki.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/stone.png")).setTextureSize(24).build()).setName((Component)Component.translatable((String)"skill.gokiskills.fortune.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.fortune.desc")).setCalcCost(level -> 25.0 * Math.pow(level.intValue(), 2.0) + (double)(25 * level) + 100.0).build();
    public static final ISkill HEALTH = new Skill.Builder().setCategory(abilityCategory).setMaxLevel(40).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.RED)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("gokiskills", "textures/gui/icon/instant_health.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/crimson_planks.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.health.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.health.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus, 0)})).setCalcCost(level -> Math.pow(level.intValue(), 2.0) + 48.0 + (double)level.intValue()).setCalcBonus(Double::valueOf).build();
    public static final ISkill LEAPER = new Skill.Builder().setCategory(abilityCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.WHITE)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("gokiskills", "textures/gui/icon/leaper.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/birch_planks.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.leaper.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.leaper.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2)})).build();
    public static final ISkill SWIMMING = new Skill.Builder().setCategory(abilityCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.LIGHT_BLUE)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/mob_effect/dolphins_grace.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("gokiskills", "textures/gui/background/water.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.swimming.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.swimming.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2), GokiUtils.doubleToString(bonus * 25.0, 2)})).build();
    public static final ISkill JUMP_BOOST = new Skill.Builder().setCategory(abilityCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.WHITE)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/mob_effect/jump_boost.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/birch_planks.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.jump_boost.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.jump_boost.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2)})).build();
    public static final ISkill CHOPPING = new Skill.Builder().setCategory(breakingCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.BROWN)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/item/diamond_axe.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/oak_log.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.chopping.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.chopping.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2)})).build();
    public static final ISkill DIGGING = new Skill.Builder().setCategory(breakingCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.LIGHT_GRAY)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/item/diamond_shovel.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/gravel.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.digging.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.digging.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2)})).build();
    public static final ISkill HARVESTING = new Skill.Builder().setCategory(breakingCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.YELLOW)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/item/diamond_hoe.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("minecraft", "textures/block/hay_block_side.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.harvesting.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.harvesting.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2)})).build();
    public static final ISkill MINING = new Skill.Builder().setCategory(breakingCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.GRAY)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/item/diamond_pickaxe.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/stone.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.mining.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.mining.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2)})).build();
    public static final ISkill SHEARING = new Skill.Builder().setCategory(breakingCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.YELLOW)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/item/shears.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/yellow_wool.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.shearing.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.shearing.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2)})).build();
    public static final ISkill ALCHEMY = new Skill.Builder().setCategory(professionCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.YELLOW)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/item/raw_iron.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/gold_block.png")).setTextureSize(24).build()).setName((Component)Component.translatable((String)"skill.gokiskills.alchemy.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.alchemy.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2)})).build();
    public static final ISkill ARCHER = new Skill.Builder().setCategory(professionCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.RED)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/item/bow_pulling_0.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("gokiskills", "textures/gui/background/archer.png")).setTextureSize(24).build()).setName((Component)Component.translatable((String)"skill.gokiskills.archer.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.archer.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2)})).build();
    public static final ISkill BOXING = new Skill.Builder().setCategory(professionCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.RED)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("gokiskills", "textures/gui/icon/boxing.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/bricks.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.boxing.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.boxing.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2)})).build();
    public static final ISkill FENCING = new Skill.Builder().setCategory(professionCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.PINK)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/item/iron_sword.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/cherry_planks.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.fencing.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.fencing.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2)})).build();
    public static final ISkill NINJA = new Skill.Builder().setCategory(professionCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.BLACK)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("gokiskills", "textures/gui/icon/ninja.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/chiseled_polished_blackstone.png")).setTextureSize(24).build()).setName((Component)Component.translatable((String)"skill.gokiskills.ninja.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.ninja.desc", (Object[])new Object[]{GokiUtils.doubleToString(bonus * 100.0, 2), GokiUtils.doubleToString(bonus * 25.0, 2)})).build();
    public static final ISkill ONE_HIT = new Skill.Builder().setCategory(professionCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.RED)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("gokiskills", "textures/gui/icon/sickle.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/red_terracotta.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.one_hit.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.one_hit.desc", (Object[])new Object[]{GokiUtils.doubleToString(Math.min(bonus * 100.0, 100.0), 2), GokiUtils.doubleToString(Math.min(bonus * 40.0, 100.0), 2)})).setCalcBonus(level -> 0.01 * (double)level.intValue()).build();
    public static final ISkill BLAST_PROTECTION = new Skill.Builder().setCategory(protectionCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.RED)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("gokiskills", "textures/gui/icon/creeper.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/tnt_side.png")).setTextureSize(24).build()).setName((Component)Component.translatable((String)"skill.gokiskills.blast_protection.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.blast_protection.desc", (Object[])new Object[]{GokiUtils.doubleToString(Math.min(bonus * 100.0, 100.0), 2)})).setCalcBonus(level -> 0.026 * (double)level.intValue()).build();
    public static final ISkill DODGE = new Skill.Builder().setCategory(protectionCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.WHITE)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("gokiskills", "textures/gui/icon/wind_charged.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("gokiskills", "textures/gui/background/pale_oak_planks.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.dodge.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.dodge.desc", (Object[])new Object[]{GokiUtils.doubleToString(Math.min(bonus * 100.0, 100.0), 2)})).setCalcBonus(level -> 0.006 * (double)level.intValue()).build();
    public static final ISkill ENDOTHERMY = new Skill.Builder().setCategory(protectionCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.LIGHT_BLUE)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/mob_effect/fire_resistance.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/ice.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.endothermy.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.endothermy.desc", (Object[])new Object[]{GokiUtils.doubleToString(Math.min(bonus * 100.0, 100.0), 2)})).setCalcBonus(level -> 0.026 * (double)level.intValue()).build();
    public static final ISkill FEATHER_FALLING = new Skill.Builder().setCategory(protectionCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.WHITE)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/item/feather.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/sand.png")).setTextureSize(16).build()).setName((Component)Component.translatable((String)"skill.gokiskills.feather_falling.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.feather_falling.desc", (Object[])new Object[]{GokiUtils.doubleToString(Math.min(bonus * 100.0, 100.0), 2)})).setCalcBonus(level -> 0.026 * (double)level.intValue()).build();
    public static final ISkill KNOCKBACK_RESISTANCE = new Skill.Builder().setCategory(protectionCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.WHITE)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/mob_effect/absorption.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/iron_block.png")).setTextureSize(24).build()).setName((Component)Component.translatable((String)"skill.gokiskills.knockback_resistence.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.knockback_resistence.desc", (Object[])new Object[]{GokiUtils.doubleToString(Math.min(bonus * 100.0, 100.0), 2)})).setCalcBonus(level -> 0.013 * (double)level.intValue()).build();
    public static final ISkill PROTECTION = new Skill.Builder().setCategory(protectionCategory).setFrame(SkillTextures.getFrame(SkillTextures.FrameColor.GRAY)).setIcon(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/mob_effect/resistance.png")).setTextureSize(16).build()).setBackground(new SkillTexture.Builder().setDefaultImage(new ResourceLocation("textures/block/netherite_block.png")).setTextureSize(24).build()).setName((Component)Component.translatable((String)"skill.gokiskills.protection.name")).setDescription((level, bonus) -> Component.translatable((String)"skill.gokiskills.protection.desc", (Object[])new Object[]{GokiUtils.doubleToString(Math.min(bonus * 100.0, 100.0), 2)})).setCalcBonus(level -> 0.008 * (double)level.intValue()).build();

    public static ISkill bootstrap(Registry<ISkill> registry) {
        Skills.register(registry, "climbing", CLIMBING);
        Skills.register(registry, "health", HEALTH);
        Skills.register(registry, "jump_boost", JUMP_BOOST);
        Skills.register(registry, "leaper", LEAPER);
        Skills.register(registry, "chopping", CHOPPING);
        Skills.register(registry, "digging", DIGGING);
        Skills.register(registry, "harvesting", HARVESTING);
        Skills.register(registry, "mining", MINING);
        Skills.register(registry, "shearing", SHEARING);
        Skills.register(registry, "archer", ARCHER);
        Skills.register(registry, "boxing", BOXING);
        Skills.register(registry, "fencing", FENCING);
        Skills.register(registry, "ninja", NINJA);
        Skills.register(registry, "one_hit", ONE_HIT);
        Skills.register(registry, "blast_protection", BLAST_PROTECTION);
        Skills.register(registry, "dodge", DODGE);
        Skills.register(registry, "endothermy", ENDOTHERMY);
        Skills.register(registry, "feather_falling", FEATHER_FALLING);
        Skills.register(registry, "knockback_resistence", KNOCKBACK_RESISTANCE);
        return Skills.register(registry, "protection", PROTECTION);
    }

    private static ISkill register(Registry<ISkill> registry, String path, ISkill skill) {
        return (ISkill)Registry.register(registry, (ResourceLocation)new ResourceLocation("gokiskills", path), (Object)skill);
    }
}

