/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.client.gui.screens;

import io.github.tigercrl.gokiskills.client.GokiSkillsClient;
import io.github.tigercrl.gokiskills.client.gui.components.SkillButton;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillHelper;
import io.github.tigercrl.gokiskills.skill.SkillRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7413;

@Environment(value=EnvType.CLIENT)
public class SkillsMenuScreen
extends class_437 {
    private static final class_2561 LOADING = class_2561.method_43471((String)"gui.gokiskills.loading.menu");
    private static final class_2561 LEFT_BOTTOM = System.getProperty("os.name").toLowerCase().contains("mac") ? class_2561.method_43471((String)"gui.gokiskills.help.macos") : class_2561.method_43471((String)"gui.gokiskills.help");
    public static final int HORIZONTAL_SPACING = 10;
    public static final int VERTICAL_SPACING = 17;
    public static int playerXp = 0;
    private final class_437 parent;
    private long lastUpdated = -1L;
    private boolean loaded = false;

    public SkillsMenuScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"gui.gokiskills.title"));
        this.parent = parent;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    protected void method_25426() {
        if (this.loaded) {
            this.onLoaded();
        }
    }

    protected void onLoaded() {
        List<List<ISkill>> skills = SkillRegistry.getSortedSkills();
        List<Integer> lineHeight = skills.stream().map(row -> row.stream().mapToInt(s -> s.getWidgetSize()[1]).max().orElse(24)).toList();
        int height = (skills.size() - 1) * 17 + lineHeight.stream().reduce(0, Integer::sum);
        int yStart = (this.field_22790 - height) / 2 - 5;
        for (int i = 0; i < skills.size(); ++i) {
            List<ISkill> row2 = skills.get(i);
            int y = yStart + i * 17 + lineHeight.stream().limit(i).reduce(0, Integer::sum);
            List<Integer> widths = row2.stream().map(s -> s.getWidgetSize()[0]).toList();
            int width = (row2.size() - 1) * 10 + widths.stream().reduce(0, Integer::sum);
            int xStart = (this.field_22789 - width) / 2;
            for (int j = 0; j < row2.size(); ++j) {
                int x = xStart + j * 10 + widths.stream().limit(j).reduce(0, Integer::sum);
                ISkill skill = row2.get(j);
                this.method_37063((class_364)skill.getWidget(x, y));
            }
        }
    }

    public void method_25393() {
        super.method_25393();
        if (!this.loaded && GokiSkillsClient.serverConfig != null && SkillHelper.getClientInfoOrNull() != null) {
            this.loaded = true;
            this.onLoaded();
        }
        playerXp = SkillHelper.getClientTotalXp();
        if (GokiSkillsClient.lastPlayerInfoUpdated > this.lastUpdated) {
            this.lastUpdated = GokiSkillsClient.lastPlayerInfoUpdated;
            for (int i = 0; i < this.method_25396().size(); ++i) {
                Object e = this.method_25396().get(i);
                if (!(e instanceof SkillButton)) continue;
                SkillButton button = (SkillButton)((Object)e);
                button.updateLevel();
            }
        }
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        this.method_25420(guiGraphics, i, j, f);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        SkillButton.hasControlDown = SkillsMenuScreen.method_25441();
        SkillButton.hasShiftDown = SkillsMenuScreen.method_25442();
        SkillButton.hasAltDown = SkillsMenuScreen.method_25443();
        if (!this.loaded) {
            String s = class_7413.method_43449((long)class_156.method_658());
            guiGraphics.method_25300(this.field_22793, s, this.field_22789 / 2, this.field_22790 / 2 - 6, 0x808080);
            guiGraphics.method_27534(this.field_22793, LOADING, this.field_22789 / 2, this.field_22790 / 2 + 6, 0xFFFFFF);
        } else {
            super.method_25394(guiGraphics, i, j, f);
            class_2561[] leftBottoms = (class_2561[])Arrays.stream(LEFT_BOTTOM.getString().split("\n")).map(class_2561::method_43470).toArray(class_2561[]::new);
            for (int k = 0; k < leftBottoms.length; ++k) {
                class_2561 class_25612 = leftBottoms[k];
                Objects.requireNonNull(this.field_22793);
                guiGraphics.method_27535(this.field_22793, class_25612, 5, this.field_22790 - 9 * (leftBottoms.length - k) - 4, 0xFFFFFF);
            }
            class_5250 RIGHT_BOTTOM = class_2561.method_43469((String)"gui.gokiskills.xp", (Object[])new Object[]{SkillHelper.getClientTotalXp()});
            int n = this.field_22789 - this.field_22793.method_27525((class_5348)RIGHT_BOTTOM) - 4;
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_27535(this.field_22793, (class_2561)RIGHT_BOTTOM, n, this.field_22790 - 9 - 4, 0xFFFFFF);
            for (int k = 0; k < this.method_25396().size(); ++k) {
                Object e = this.method_25396().get(k);
                if (!(e instanceof SkillButton)) continue;
                SkillButton button = (SkillButton)((Object)e);
                button.renderTooltip(guiGraphics, i, j);
            }
        }
    }

    public boolean method_25404(int i, int j, int k) {
        return super.method_25404(i, j, k);
    }
}

