/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.client.gui.utils;

import io.github.tigercrl.gokiskills.client.gui.utils.SkillResource;
import net.minecraft.class_2960;

public class SkillTexture
extends SkillResource<class_2960> {
    private final int textureWidth;
    private final int textureHeight;

    public SkillTexture(class_2960 defaultImage, class_2960 hoverImage, class_2960 maxLevelImage, class_2960 operationImage, class_2960 operationHoverImage, int textureWidth, int textureHeight) {
        super(defaultImage, hoverImage, maxLevelImage, operationImage, operationHoverImage);
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public static class Builder {
        private class_2960 defaultImage;
        private class_2960 hoverImage;
        private class_2960 maxLevelImage;
        private class_2960 operationImage;
        private class_2960 operationHoverImage;
        private int textureWidth;
        private int textureHeight;

        public Builder setDefaultImage(class_2960 defaultImage) {
            this.defaultImage = defaultImage;
            return this;
        }

        public Builder setHoverImage(class_2960 hoverImage) {
            this.hoverImage = hoverImage;
            return this;
        }

        public Builder setMaxLevelImage(class_2960 maxLevelImage) {
            this.maxLevelImage = maxLevelImage;
            return this;
        }

        public Builder setOperationImage(class_2960 operationImage) {
            this.operationImage = operationImage;
            return this;
        }

        public Builder setOperationHoverImage(class_2960 operationHoverImage) {
            this.operationHoverImage = operationHoverImage;
            return this;
        }

        public Builder setTextureSize(int textureWidth, int textureHeight) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            return this;
        }

        public Builder setTextureSize(int textureSize) {
            this.textureWidth = textureSize;
            this.textureHeight = textureSize;
            return this;
        }

        public Builder setTextureWidth(int textureWidth) {
            this.textureWidth = textureWidth;
            return this;
        }

        public Builder setTextureHeight(int textureHeight) {
            this.textureHeight = textureHeight;
            return this;
        }

        public SkillTexture build() {
            if (this.defaultImage == null) {
                throw new IllegalStateException("Default image must be set");
            }
            if (this.textureWidth <= 0) {
                throw new IllegalStateException("Texture width must be set and greater than 0");
            }
            if (this.textureHeight <= 0) {
                throw new IllegalStateException("Texture height must be set and greater than 0");
            }
            return new SkillTexture(this.defaultImage, this.hoverImage == null ? this.defaultImage : this.hoverImage, this.maxLevelImage == null ? this.defaultImage : this.maxLevelImage, this.operationImage == null ? this.defaultImage : this.operationImage, this.operationHoverImage == null ? (this.operationImage == null ? this.defaultImage : this.operationImage) : this.operationHoverImage, this.textureWidth, this.textureHeight);
        }
    }
}

