/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import dev.architectury.event.events.common.PlayerEvent;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillEvents;
import io.github.tigercrl.gokiskills.skill.SkillHelper;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import io.github.tigercrl.gokiskills.skill.Skills;
import java.util.UUID;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class SkillHooks {
    public static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("ac28fc4a-8ee1-4998-87b6-cdfe8754b2d6");
    public static final UUID KNOCKBACK_RESISTANCE_MODIFIER_UUID = UUID.fromString("44352496-cb58-4ce3-a261-facd73f08190");
    public static final UUID NINJA_SPEED_MODIFIER_UUID = UUID.fromString("a1e60be0-0511-45a3-aa37-5b217b23c9ad");

    public static void register() {
        PlayerEvent.PLAYER_JOIN.register(SkillHooks::updateAttributes);
        PlayerEvent.PLAYER_RESPAWN.register((player, conqueredEnd) -> {
            SkillHooks.updateAttributes(player);
            player.method_6033(player.method_6063());
        });
        SkillEvents.UPDATE.register((skill, player, newLevel, oldLevel, info) -> {
            if (player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                SkillHooks.updateAttribute(sp, info, skill);
            }
        });
        SkillEvents.TOGGLE.register((skill, player, newState, info) -> {
            if (player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                SkillHooks.updateAttribute(sp, info, skill);
            }
        });
    }

    public static void updateAttributes(class_3222 player) {
        SkillInfo info = SkillHelper.getInfo((class_1657)player);
        SkillHooks.updateAttribute(player, info, Skills.KNOCKBACK_RESISTANCE);
        SkillHooks.updateAttribute(player, info, Skills.HEALTH);
    }

    public static void updateAttribute(class_3222 player, SkillInfo info, ISkill skill) {
        if (skill == Skills.KNOCKBACK_RESISTANCE) {
            SkillHooks.updateAttribute(player, info, Skills.KNOCKBACK_RESISTANCE, class_5134.field_23718, KNOCKBACK_RESISTANCE_MODIFIER_UUID, "GokiSkills knockback resistance", class_1322.class_1323.field_6328);
        } else if (skill == Skills.HEALTH) {
            SkillHooks.updateAttribute(player, info, Skills.HEALTH, class_5134.field_23716, HEALTH_MODIFIER_UUID, "GokiSkills health", class_1322.class_1323.field_6328);
        }
    }

    public static void updateAttribute(class_3222 player, SkillInfo info, ISkill skill, class_1320 attribute, UUID uuid, String name, class_1322.class_1323 operation) {
        SkillHooks.updateAttribute(player, info, skill, attribute, uuid, name, operation, true);
    }

    public static void updateAttribute(class_3222 player, SkillInfo info, ISkill skill, class_1320 attribute, UUID uuid, String name, class_1322.class_1323 operation, boolean condition) {
        double bonus = info.getBonus(skill);
        class_1324 instance = player.method_5996(attribute);
        class_1322 oldModifier = instance.method_6199(uuid);
        if (condition && info.isEnabled(skill) && bonus > 0.0) {
            if (oldModifier == null || oldModifier.method_6186() != bonus) {
                instance.method_6200(uuid);
                instance.method_26835(new class_1322(uuid, name, bonus, operation));
            }
        } else if (oldModifier != null) {
            instance.method_6200(uuid);
        }
    }
}

