/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import io.github.tigercrl.gokiskills.GokiSkills;
import io.github.tigercrl.gokiskills.misc.GokiServerPlayer;
import io.github.tigercrl.gokiskills.misc.GokiUtils;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillEvents;
import io.github.tigercrl.gokiskills.skill.SkillRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class SkillInfo {
    public final int SCHEMA_VERSION = 1;
    private final class_1657 player;
    private final Map<class_2960, Integer> levels;
    private final Set<class_2960> disabled;

    public SkillInfo(class_1657 player) {
        this(player, new HashMap<class_2960, Integer>(), new HashSet<class_2960>());
    }

    protected SkillInfo(class_1657 player, Map<class_2960, Integer> levels, Set<class_2960> disabled) {
        this.player = player;
        this.levels = levels;
        this.disabled = disabled;
        SkillRegistry.getSkills().forEach(skill -> levels.putIfAbsent(skill.getLocation(), skill.getDefaultLevel()));
    }

    public int getLevel(ISkill skill) {
        return this.levels.get(skill.getLocation());
    }

    public int getLevel(class_2960 location) {
        return this.getLevel(SkillRegistry.getSkill(location));
    }

    @Nullable
    public Double getBonus(ISkill skill) {
        return skill.calcBonus(this.isEnabled(skill) ? this.getLevel(skill) : skill.getDefaultLevel());
    }

    @Nullable
    public Double getBonus(class_2960 location) {
        return this.getBonus(SkillRegistry.getSkill(location));
    }

    public void setLevel(ISkill skill, int level) {
        this.levels.put(skill.getLocation(), level);
        ((SkillEvents.SkillInfoUpdate)SkillEvents.UPDATE.invoker()).update(skill, this.player, level, this.getLevel(skill), this);
        this.sync();
    }

    public void setLevel(class_2960 location, int level) {
        this.setLevel(SkillRegistry.getSkill(location), level);
    }

    public boolean isEnabled(ISkill skill) {
        return skill.isEnabled() && !this.disabled.contains(skill.getLocation());
    }

    public boolean isEnabled(class_2960 location) {
        return this.isEnabled(SkillRegistry.getSkill(location));
    }

    public void toggle(ISkill skill) {
        if (this.isEnabled(skill.getLocation())) {
            this.disabled.add(skill.getLocation());
        } else {
            this.disabled.remove(skill.getLocation());
        }
        ((SkillEvents.SkillInfoToggle)SkillEvents.TOGGLE.invoker()).toggle(skill, this.player, this.isEnabled(skill), this);
        this.sync();
    }

    public void toggle(class_2960 location) {
        this.toggle(SkillRegistry.getSkill(location));
    }

    public void onDeath() {
        if (GokiSkills.config.lostLevelOnDeath.enabled) {
            this.levels.forEach((key, value) -> {
                boolean lost;
                boolean bl = lost = Math.random() < GokiSkills.config.lostLevelOnDeath.chance;
                if (lost) {
                    ISkill s = SkillRegistry.getSkill(key);
                    int lostLevel = Math.min(GokiUtils.randomInt(GokiSkills.config.lostLevelOnDeath.minLevel, GokiSkills.config.lostLevelOnDeath.maxLevel + 1), value - s.getMinLevel());
                    if (lostLevel > 0) {
                        this.levels.put((class_2960)key, value - lostLevel);
                        this.sync();
                    }
                }
            });
        }
    }

    public void sync() {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof GokiServerPlayer) {
            GokiServerPlayer gp = (GokiServerPlayer)class_16572;
            gp.syncSkillInfo();
        }
    }

    @Nullable
    public class_2487 toNbt() {
        class_2487 compoundTag = new class_2487();
        class_2487 levelTag = new class_2487();
        this.levels.forEach((key, value) -> levelTag.method_10569(key.toString(), value.intValue()));
        compoundTag.method_10566("levels", (class_2520)levelTag);
        class_2499 disabledTag = new class_2499();
        this.disabled.forEach(key -> disabledTag.add((Object)class_2519.method_23256((String)key.toString())));
        compoundTag.method_10566("disabled", (class_2520)disabledTag);
        compoundTag.method_10569("schema", 1);
        return compoundTag;
    }

    public void writeBuf(class_2540 buf) {
        buf.method_34063(this.levels, class_2540::method_10812, class_2540::method_10804);
        buf.method_34062(this.disabled, class_2540::method_10812);
    }

    public static SkillInfo fromBuf(class_1657 player, class_2540 buf) {
        return new SkillInfo(player, new HashMap<class_2960, Integer>(buf.method_34067(class_2540::method_10810, class_2540::method_10816)), (Set)buf.method_34068(HashSet::new, class_2540::method_10810));
    }

    public static SkillInfo fromNbt(class_1657 player, class_2487 compoundTag) {
        HashMap<class_2960, Integer> levels = new HashMap<class_2960, Integer>();
        HashSet<class_2960> disabled = new HashSet<class_2960>();
        if (compoundTag.method_10545("schema")) {
            switch (compoundTag.method_10550("schema")) {
                case 1: {
                    SkillInfo.readVer1(compoundTag, levels, disabled);
                }
            }
        } else if (compoundTag.method_10545("levels")) {
            SkillInfo.readVer1(compoundTag, levels, disabled);
        } else {
            SkillInfo.readVer0(compoundTag, levels);
        }
        return new SkillInfo(player, levels, disabled);
    }

    private static void readVer0(class_2487 compoundTag, Map<class_2960, Integer> levels) {
        compoundTag.method_10541().forEach(key -> levels.put(class_2960.method_12829((String)key), compoundTag.method_10550(key)));
    }

    private static void readVer1(class_2487 compoundTag, Map<class_2960, Integer> levels, Set<class_2960> disabled) {
        class_2487 levelTag = compoundTag.method_10562("levels");
        levelTag.method_10541().forEach(key -> levels.put(class_2960.method_12829((String)key), levelTag.method_10550(key)));
        if (compoundTag.method_10545("disabled")) {
            compoundTag.method_10554("disabled", 8).forEach(tag -> disabled.add(class_2960.method_12829((String)tag.method_10714())));
        }
    }
}

