/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.Message;
import dev.architectury.networking.simple.MessageDecoder;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.networking.simple.SimpleNetworkManager;
import io.github.tigercrl.gokiskills.network.C2SDowngradeMessage;
import io.github.tigercrl.gokiskills.network.C2SFastDowngradeMessage;
import io.github.tigercrl.gokiskills.network.C2SFastUpgradeMessage;
import io.github.tigercrl.gokiskills.network.C2SRequestConfigMessage;
import io.github.tigercrl.gokiskills.network.C2SRequestSkillInfoMessage;
import io.github.tigercrl.gokiskills.network.C2SToggleMessage;
import io.github.tigercrl.gokiskills.network.C2SUpgradeMessage;
import io.github.tigercrl.gokiskills.network.S2CSyncConfigMessage;
import io.github.tigercrl.gokiskills.network.S2CSyncSkillInfoMessage;
import net.minecraft.network.FriendlyByteBuf;

public interface GokiNetwork {
    public static final SimpleNetworkManager NET = SimpleNetworkManager.create((String)"gokiskills");
    public static final MessageType REQUEST_CONFIG = NET.registerC2S("request_config", buf -> new C2SRequestConfigMessage());
    public static final MessageType SYNC_CONFIG = NET.registerS2C("sync_config", S2CSyncConfigMessage::new);
    public static final MessageType REQUEST_SKILL_INFO = NET.registerC2S("request_skill_info", buf -> new C2SRequestSkillInfoMessage());
    public static final MessageType SYNC_SKILL_INFO = NET.registerS2C("sync_skill_info", (MessageDecoder)new MessageDecoder<BaseS2CMessage>(){

        public BaseS2CMessage decode(FriendlyByteBuf buf) {
            return null;
        }

        public NetworkManager.NetworkReceiver createReceiver() {
            return (buf, context) -> {
                S2CSyncSkillInfoMessage packet = new S2CSyncSkillInfoMessage(context.getPlayer(), buf);
                context.queue(() -> 1.lambda$createReceiver$0((Message)packet, context));
            };
        }

        private static /* synthetic */ void lambda$createReceiver$0(Message packet, NetworkManager.PacketContext context) {
            packet.handle(context);
        }
    });
    public static final MessageType SKILL_UPGRADE = NET.registerC2S("skill_upgrade", C2SUpgradeMessage::new);
    public static final MessageType SKILL_FAST_UPGRADE = NET.registerC2S("skill_fast_upgrade", C2SFastUpgradeMessage::new);
    public static final MessageType SKILL_DOWNGRADE = NET.registerC2S("skill_downgrade", C2SDowngradeMessage::new);
    public static final MessageType SKILL_FAST_DOWNGRADE = NET.registerC2S("skill_fast_downgrade", C2SFastDowngradeMessage::new);
    public static final MessageType SKILL_TOGGLE = NET.registerC2S("skill_toggle", C2SToggleMessage::new);
}

