/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import io.github.tigercrl.gokiskills.GokiSkills;
import io.github.tigercrl.gokiskills.client.gui.SkillTexture;
import io.github.tigercrl.gokiskills.client.gui.SkillTextures;
import io.github.tigercrl.gokiskills.client.gui.components.SkillButton;
import io.github.tigercrl.gokiskills.config.GokiSkillConfig;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class Skill
implements ISkill {
    public static final Function<Integer, Double> DEFAULT_CALC_COST = level -> Math.pow(level.intValue(), 1.6) + 6.0 + (double)level.intValue();
    public static final BiFunction<Integer, Function<Integer, Double>, Double> DEFAULT_CALC_RETURN = (level, calcCost) -> (Double)calcCost.apply(level - 1);
    public static final Function<Integer, Double> DEFAULT_CALC_BONUS = level -> 0.04 * (double)level.intValue();
    private final ResourceLocation category;
    private final Function<Integer, Double> calcCost;
    private final BiFunction<Integer, Function<Integer, Double>, Double> calcReturn;
    @Nullable
    private final Function<Integer, Double> calcBonus;
    private final SkillTexture icon;
    private final SkillTexture frame;
    private final SkillTexture overlay;
    private final SkillTexture background;
    private final Component name;
    private final SkillDescription description;
    private final Class<? extends GokiSkillConfig> configClass;
    private final GokiSkillConfig defaultConfig;

    public Skill(ResourceLocation category, Function<Integer, Double> calcCost, BiFunction<Integer, Function<Integer, Double>, Double> calcReturn, @Nullable Function<Integer, Double> calcBonus, SkillTexture icon, SkillTexture frame, SkillTexture overlay, SkillTexture background, Component name, SkillDescription description, Class<? extends GokiSkillConfig> configClass, GokiSkillConfig defaultConfig) {
        this.category = category;
        this.calcCost = calcCost;
        this.calcReturn = calcReturn;
        this.calcBonus = calcBonus;
        this.icon = icon;
        this.frame = frame;
        this.overlay = overlay;
        this.background = background;
        this.name = name;
        this.description = description;
        this.configClass = configClass;
        this.defaultConfig = defaultConfig;
    }

    @Override
    public boolean isEnabled() {
        return GokiSkills.getConfig() != null && ((GokiSkillConfig)this.getConfig()).enabled;
    }

    @Override
    public ResourceLocation getLocation() {
        return SkillRegistry.getLocation(this);
    }

    @Override
    public ResourceLocation getCategory() {
        return this.category;
    }

    @Override
    public int getMaxLevel() {
        return ((GokiSkillConfig)this.getConfig()).maxLevel;
    }

    @Override
    public int getDefaultLevel() {
        return ((GokiSkillConfig)this.getConfig()).defaultLevel;
    }

    @Override
    public int getMinLevel() {
        return ((GokiSkillConfig)this.getConfig()).minLevel;
    }

    @Override
    public int calcCost(int level) {
        return Math.toIntExact(Math.round(this.calcCost.apply(level) * ((GokiSkillConfig)this.getConfig()).costMultiplier));
    }

    @Override
    public int calcReturn(int level) {
        return Math.toIntExact(Math.round(this.calcReturn.apply(level, this.calcCost) * ((GokiSkillConfig)this.getConfig()).downgradeReturnFactor));
    }

    @Override
    @Nullable
    public Double calcBonus(int level) {
        if (this.calcBonus == null) {
            return null;
        }
        return this.calcBonus.apply(level) * ((GokiSkillConfig)this.getConfig()).bonusMultiplier;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public AbstractWidget getWidget(int x, int y) {
        return new SkillButton(x, y, this);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int[] getWidgetSize() {
        return new int[]{24, 24};
    }

    public SkillTexture getIcon() {
        return this.icon;
    }

    public SkillTexture getFrame() {
        return this.frame;
    }

    public SkillTexture getOverlay() {
        return this.overlay;
    }

    public SkillTexture getBackground() {
        return this.background;
    }

    @Override
    public Component getName() {
        return this.name;
    }

    @Override
    public Component getDescription(int level, @Nullable Double bonus) {
        return this.description.getDescription(level, bonus);
    }

    @Override
    public Class<? extends GokiSkillConfig> getConfigClass() {
        return this.configClass;
    }

    @Override
    public GokiSkillConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Skill that = (Skill)obj;
        return Objects.equals(this.getLocation(), that.getLocation());
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    public static interface SkillDescription {
        public Component getDescription(int var1, @Nullable Double var2);
    }

    public static class Builder {
        private ResourceLocation category;
        private int maxLevel = 25;
        private int defaultLevel = 0;
        private int minLevel = 0;
        private Function<Integer, Double> calcCost = DEFAULT_CALC_COST;
        private BiFunction<Integer, Function<Integer, Double>, Double> calcReturn = DEFAULT_CALC_RETURN;
        @Nullable
        private Function<Integer, Double> calcBonus = DEFAULT_CALC_BONUS;
        private SkillTexture icon;
        private SkillTexture frame;
        private SkillTexture overlay = SkillTextures.DEFAULT_OVERLAY;
        private SkillTexture background;
        private Component name;
        private SkillDescription description;
        private Class<? extends GokiSkillConfig> configClass = GokiSkillConfig.class;
        private GokiSkillConfig defaultConfig;

        public Builder setCategory(ResourceLocation category) {
            this.category = category;
            return this;
        }

        public Builder setMaxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        public Builder setDefaultLevel(int defaultLevel) {
            this.defaultLevel = defaultLevel;
            return this;
        }

        public Builder setMinLevel(int minLevel) {
            this.minLevel = minLevel;
            return this;
        }

        public Builder setCalcCost(Function<Integer, Double> calcCost) {
            this.calcCost = calcCost;
            return this;
        }

        public Builder setCalcReturn(BiFunction<Integer, Function<Integer, Double>, Double> calcReturn) {
            this.calcReturn = calcReturn;
            return this;
        }

        public Builder setCalcBonus(@Nullable Function<Integer, Double> calcBonus) {
            this.calcBonus = calcBonus;
            return this;
        }

        public Builder setIcon(SkillTexture icon) {
            this.icon = icon;
            return this;
        }

        public Builder setFrame(SkillTexture frame) {
            this.frame = frame;
            return this;
        }

        public Builder setOverlay(SkillTexture overlay) {
            this.overlay = overlay;
            return this;
        }

        public Builder setBackground(SkillTexture background) {
            this.background = background;
            return this;
        }

        public Builder setName(Component name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(SkillDescription description) {
            this.description = description;
            return this;
        }

        public Builder setConfigClass(Class<? extends GokiSkillConfig> configClass) {
            this.configClass = configClass;
            return this;
        }

        public Builder setDefaultConfig(GokiSkillConfig defaultConfig) {
            this.defaultConfig = defaultConfig;
            return this;
        }

        public Skill build() {
            if (this.category == null) {
                throw new IllegalStateException("Category must be set");
            }
            if (this.icon == null) {
                throw new IllegalStateException("Icon must be set");
            }
            if (this.frame == null) {
                throw new IllegalStateException("Frame must be set");
            }
            if (this.background == null) {
                throw new IllegalStateException("Background must be set");
            }
            if (this.name == null) {
                throw new IllegalStateException("Name must be set");
            }
            if (this.description == null) {
                throw new IllegalStateException("Description must be set");
            }
            if (this.configClass == null) {
                throw new IllegalStateException("Config class must be set");
            }
            if (this.defaultConfig == null) {
                try {
                    this.defaultConfig = this.configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException("Default config must be set");
                }
            }
            this.defaultConfig.defaultLevel = this.defaultLevel;
            this.defaultConfig.maxLevel = this.maxLevel;
            this.defaultConfig.minLevel = this.minLevel;
            return new Skill(this.category, this.calcCost, this.calcReturn, this.calcBonus, this.icon, this.frame, this.overlay, this.background, this.name, this.description, this.configClass, this.defaultConfig);
        }
    }
}

