/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.config;

import com.google.gson.JsonObject;
import io.github.tigercrl.gokiskills.config.ConfigException;
import io.github.tigercrl.gokiskills.config.ConfigUtils;
import io.github.tigercrl.gokiskills.config.GokiConfig;
import io.github.tigercrl.gokiskills.config.GokiSkillConfig;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class CommonConfig
implements GokiConfig {
    public LostLevelOnDeath lostLevelOnDeath = new LostLevelOnDeath();
    public Map<String, JsonObject> skills = SkillRegistry.getDefaultConfigs();

    @Override
    public void validatePostLoad() throws ConfigException {
        if (this.lostLevelOnDeath.chance < 0.0 || this.lostLevelOnDeath.chance > 1.0) {
            throw new ConfigException("Lost level on death chance must be between 0.0 and 1.0");
        }
        if (this.lostLevelOnDeath.minLevel < 0 || this.lostLevelOnDeath.maxLevel < 0) {
            throw new ConfigException("Lost level on death levels cannot be negative");
        }
        if (this.lostLevelOnDeath.minLevel > this.lostLevelOnDeath.maxLevel) {
            throw new ConfigException("Lost level on death min level cannot be greater than max level");
        }
        this.skills = new HashMap<String, JsonObject>(this.skills);
        SkillRegistry.getDefaultConfigs().forEach((key, value) -> this.skills.putIfAbsent((String)key, (JsonObject)value));
        this.skills.forEach((key, value) -> {
            try {
                ISkill skill = SkillRegistry.getSkill(ResourceLocation.m_135820_((String)key));
                GokiSkillConfig config = ConfigUtils.fromJsonObject(value, skill.getConfigClass());
                if (!value.has("minLevel")) {
                    GokiSkillConfig defaultConfig = skill.getDefaultConfig();
                    boolean enabled = config.enabled;
                    config = defaultConfig;
                    config.enabled = enabled;
                }
                config.validatePostLoad();
                this.skills.put((String)key, ConfigUtils.toJsonObject(config));
            }
            catch (ConfigException e) {
                throw new ConfigException("Invalid skill config for " + key + ": " + e.getMessage());
            }
        });
        this.skills = Map.copyOf(this.skills);
    }

    public static class LostLevelOnDeath {
        public boolean enabled = false;
        public double chance = 0.5;
        public int minLevel = 1;
        public int maxLevel = 1;
    }
}

