/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.mixin;

import io.github.tigercrl.gokiskills.misc.GokiTags;
import io.github.tigercrl.gokiskills.mixin.EntityAccessor;
import io.github.tigercrl.gokiskills.skill.SkillHelper;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import io.github.tigercrl.gokiskills.skill.Skills;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    protected boolean f_20899_;
    @Unique
    private static final List<LivingEntity> gokiskills$ignoreEntityHurt = new ArrayList<LivingEntity>();

    @Shadow
    public abstract boolean m_6147_();

    @Inject(method={"handleRelativeFrictionAndCalculateMovement"}, at={@At(value="RETURN")}, cancellable=true)
    public void climbBonus(Vec3 vec3, float f, CallbackInfoReturnable<Vec3> cir) {
        Player player;
        SkillInfo info;
        Entity entity = (Entity)this;
        if (entity instanceof Player && (info = SkillHelper.getInfo(player = (Player)entity)).isEnabled(Skills.CLIMBING) && (entity.f_19862_ || this.f_20899_) && (this.m_6147_() || player.m_146900_().m_60713_(Blocks.f_152499_) && PowderSnowBlock.m_154255_((Entity)player))) {
            double bonus = info.getBonus(Skills.CLIMBING);
            Vec3 vec = player.m_20184_();
            if (bonus > 0.0 && vec.f_82480_ > 0.0) {
                cir.setReturnValue((Object)new Vec3(vec.f_82479_, 0.2 * (1.0 + bonus), vec.f_82481_));
            }
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="TAIL")})
    public void jumpBonus(CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            SkillInfo info = SkillHelper.getInfo(player);
            double jumpBoostBonus = info.isEnabled(Skills.JUMP_BOOST) ? info.getBonus(Skills.JUMP_BOOST) : 0.0;
            double leaperBonus = info.isEnabled(Skills.LEAPER) ? info.getBonus(Skills.LEAPER) : 0.0;
            player.m_20256_(player.m_20184_().m_82542_(leaperBonus + 1.0, jumpBoostBonus + 1.0, leaperBonus + 1.0));
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        SkillInfo info;
        ServerPlayer player;
        LivingEntity entity = (LivingEntity)this;
        float old = amount;
        if (gokiskills$ignoreEntityHurt.contains(entity)) {
            gokiskills$ignoreEntityHurt.remove(entity);
            return;
        }
        Entity entity2 = source.m_7639_();
        if (entity2 instanceof ServerPlayer) {
            double bonus;
            player = (ServerPlayer)entity2;
            info = SkillHelper.getInfo((Player)player);
            ItemStack item = player.m_21205_();
            if (info.isEnabled(Skills.ONE_HIT)) {
                bonus = info.getBonus(Skills.ONE_HIT);
                if ((double)entity.m_21223_() < (double)entity.m_21233_() * 0.4 * bonus && Math.random() < bonus) {
                    entity.m_21153_(0.0f);
                    entity.m_6667_(source);
                    player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"skill.gokiskills.one_hit.message").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED))));
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.m_216990_(SoundEvents.f_12313_);
                    cir.setReturnValue((Object)true);
                }
            }
            if (info.isEnabled(Skills.NINJA) && player.m_6047_() && (bonus = info.getBonus(Skills.NINJA).doubleValue()) > 0.0) {
                amount *= (float)(1.0 + bonus * 0.25);
            }
            if (info.isEnabled(Skills.ARCHER) && item.m_41720_() instanceof ProjectileWeaponItem) {
                bonus = info.getBonus(Skills.ARCHER);
                if (bonus > 0.0) {
                    amount *= (float)(1.0 + bonus);
                }
            } else if (info.isEnabled(Skills.BOXING) && item.m_41619_()) {
                bonus = info.getBonus(Skills.BOXING);
                if (bonus > 0.0) {
                    amount *= (float)(1.0 + bonus);
                }
            } else if (info.isEnabled(Skills.FENCING) && item.m_204117_(ItemTags.f_271388_) && (bonus = info.getBonus(Skills.FENCING).doubleValue()) > 0.0) {
                amount *= (float)(1.0 + bonus);
            }
        }
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).m_6673_(source) && !player.f_8941_.m_9295_()) {
            double bonus;
            info = SkillHelper.getInfo((Player)player);
            if (info.isEnabled(Skills.DODGE) && source.m_269533_(GokiTags.CAN_DODGE) && Math.random() < info.getBonus(Skills.DODGE)) {
                player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"skill.gokiskills.dodge.message").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD))));
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12315_, SoundSource.PLAYERS, 1.0f, 1.0f);
                ((EntityAccessor)((Object)this)).setInvulnerableTime(20);
                cir.setReturnValue((Object)false);
                return;
            }
            if (info.isEnabled(Skills.BLAST_PROTECTION) && source.m_269533_(DamageTypeTags.f_268415_)) {
                double bonus2 = info.getBonus(Skills.BLAST_PROTECTION);
                if (bonus2 > 0.0) {
                    amount = (float)((double)amount * (1.0 - bonus2));
                }
            } else if (info.isEnabled(Skills.ENDOTHERMY) && (source.m_269533_(DamageTypeTags.f_268745_) || source.m_269533_(DamageTypeTags.f_268419_))) {
                double bonus3 = info.getBonus(Skills.ENDOTHERMY);
                if (bonus3 > 0.0) {
                    amount = (float)((double)amount * (1.0 - bonus3));
                }
            } else if (info.isEnabled(Skills.FEATHER_FALLING) && source.m_269533_(DamageTypeTags.f_268549_)) {
                double bonus4 = info.getBonus(Skills.FEATHER_FALLING);
                if (bonus4 > 0.0) {
                    amount = Mth.m_14107_((double)((double)amount * (1.0 - bonus4)));
                }
            } else if (info.isEnabled(Skills.PROTECTION) && source.m_269533_(GokiTags.CAN_PROTECT) && (bonus = info.getBonus(Skills.PROTECTION).doubleValue()) > 0.0) {
                amount = (float)((double)amount * (1.0 - bonus));
            }
        }
        if (amount == old) {
            return;
        }
        LivingEntityMixin.gokiskills$hurtEntity(entity, source, amount);
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"calculateFallDamage"}, at={@At(value="RETURN")}, cancellable=true)
    public void jumpBoostDamage(float f, float g, CallbackInfoReturnable<Integer> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            double bonus;
            SkillInfo info;
            Player p = (Player)livingEntity;
            if ((Integer)cir.getReturnValue() > 0 && (info = SkillHelper.getInfo(p)).isEnabled(Skills.JUMP_BOOST) && (bonus = info.getBonus(Skills.JUMP_BOOST).doubleValue()) > 0.0) {
                MobEffectInstance mobEffectInstance = p.m_21124_(MobEffects.f_19603_);
                int h = mobEffectInstance == null ? 0 : mobEffectInstance.m_19564_() + 1;
                cir.setReturnValue((Object)Mth.m_14165_((double)(((double)(f - 3.0f - (float)h) - 3.5 * bonus) * (double)g)));
            }
        }
    }

    @Unique
    private static void gokiskills$hurtEntity(LivingEntity entity, DamageSource source, float amount) {
        gokiskills$ignoreEntityHurt.add(entity);
        entity.m_6469_(source, amount);
    }
}

