/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import io.github.tigercrl.gokiskills.GokiSkills;
import io.github.tigercrl.gokiskills.misc.GokiServerPlayer;
import io.github.tigercrl.gokiskills.misc.GokiUtils;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillEvents;
import io.github.tigercrl.gokiskills.skill.SkillRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class SkillInfo {
    public final int SCHEMA_VERSION = 1;
    private final Player player;
    private final Map<ResourceLocation, Integer> levels;
    private final Set<ResourceLocation> disabled;

    public SkillInfo(Player player) {
        this(player, new HashMap<ResourceLocation, Integer>(), new HashSet<ResourceLocation>());
    }

    protected SkillInfo(Player player, Map<ResourceLocation, Integer> levels, Set<ResourceLocation> disabled) {
        this.player = player;
        this.levels = levels;
        this.disabled = disabled;
        SkillRegistry.getSkills().forEach(skill -> levels.putIfAbsent(skill.getLocation(), skill.getDefaultLevel()));
    }

    public int getLevel(ISkill skill) {
        return this.levels.get(skill.getLocation());
    }

    public int getLevel(ResourceLocation location) {
        return this.getLevel(SkillRegistry.getSkill(location));
    }

    @Nullable
    public Double getBonus(ISkill skill) {
        return skill.calcBonus(this.isEnabled(skill) ? this.getLevel(skill) : skill.getDefaultLevel());
    }

    @Nullable
    public Double getBonus(ResourceLocation location) {
        return this.getBonus(SkillRegistry.getSkill(location));
    }

    public void setLevel(ISkill skill, int level) {
        this.levels.put(skill.getLocation(), level);
        ((SkillEvents.SkillInfoUpdate)SkillEvents.UPDATE.invoker()).update(skill, this.player, level, this.getLevel(skill), this);
        this.sync();
    }

    public void setLevel(ResourceLocation location, int level) {
        this.setLevel(SkillRegistry.getSkill(location), level);
    }

    public boolean isEnabled(ISkill skill) {
        return skill.isEnabled() && !this.disabled.contains(skill.getLocation());
    }

    public boolean isEnabled(ResourceLocation location) {
        return this.isEnabled(SkillRegistry.getSkill(location));
    }

    public void toggle(ISkill skill) {
        if (this.isEnabled(skill.getLocation())) {
            this.disabled.add(skill.getLocation());
        } else {
            this.disabled.remove(skill.getLocation());
        }
        ((SkillEvents.SkillInfoToggle)SkillEvents.TOGGLE.invoker()).toggle(skill, this.player, this.isEnabled(skill), this);
        this.sync();
    }

    public void toggle(ResourceLocation location) {
        this.toggle(SkillRegistry.getSkill(location));
    }

    public void onDeath() {
        if (GokiSkills.config.lostLevelOnDeath.enabled) {
            this.levels.forEach((key, value) -> {
                boolean lost;
                boolean bl = lost = Math.random() < GokiSkills.config.lostLevelOnDeath.chance;
                if (lost) {
                    ISkill s = SkillRegistry.getSkill(key);
                    int lostLevel = Math.min(GokiUtils.randomInt(GokiSkills.config.lostLevelOnDeath.minLevel, GokiSkills.config.lostLevelOnDeath.maxLevel + 1), value - s.getMinLevel());
                    if (lostLevel > 0) {
                        this.levels.put((ResourceLocation)key, value - lostLevel);
                        this.sync();
                    }
                }
            });
        }
    }

    public void sync() {
        Player player = this.player;
        if (player instanceof GokiServerPlayer) {
            GokiServerPlayer gp = (GokiServerPlayer)player;
            gp.syncSkillInfo();
        }
    }

    @Nullable
    public CompoundTag toNbt() {
        CompoundTag compoundTag = new CompoundTag();
        CompoundTag levelTag = new CompoundTag();
        this.levels.forEach((key, value) -> levelTag.m_128405_(key.toString(), value.intValue()));
        compoundTag.m_128365_("levels", (Tag)levelTag);
        ListTag disabledTag = new ListTag();
        this.disabled.forEach(key -> disabledTag.add((Object)StringTag.m_129297_((String)key.toString())));
        compoundTag.m_128365_("disabled", (Tag)disabledTag);
        compoundTag.m_128405_("schema", 1);
        return compoundTag;
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.m_236831_(this.levels, FriendlyByteBuf::m_130085_, FriendlyByteBuf::m_130130_);
        buf.m_236828_(this.disabled, FriendlyByteBuf::m_130085_);
    }

    public static SkillInfo fromBuf(Player player, FriendlyByteBuf buf) {
        return new SkillInfo(player, new HashMap<ResourceLocation, Integer>(buf.m_236847_(FriendlyByteBuf::m_130281_, FriendlyByteBuf::m_130242_)), (Set)buf.m_236838_(HashSet::new, FriendlyByteBuf::m_130281_));
    }

    public static SkillInfo fromNbt(Player player, CompoundTag compoundTag) {
        HashMap<ResourceLocation, Integer> levels = new HashMap<ResourceLocation, Integer>();
        HashSet<ResourceLocation> disabled = new HashSet<ResourceLocation>();
        if (compoundTag.m_128441_("schema")) {
            switch (compoundTag.m_128451_("schema")) {
                case 1: {
                    SkillInfo.readVer1(compoundTag, levels, disabled);
                }
            }
        } else if (compoundTag.m_128441_("levels")) {
            SkillInfo.readVer1(compoundTag, levels, disabled);
        } else {
            SkillInfo.readVer0(compoundTag, levels);
        }
        return new SkillInfo(player, levels, disabled);
    }

    private static void readVer0(CompoundTag compoundTag, Map<ResourceLocation, Integer> levels) {
        compoundTag.m_128431_().forEach(key -> levels.put(ResourceLocation.m_135820_((String)key), compoundTag.m_128451_(key)));
    }

    private static void readVer1(CompoundTag compoundTag, Map<ResourceLocation, Integer> levels, Set<ResourceLocation> disabled) {
        CompoundTag levelTag = compoundTag.m_128469_("levels");
        levelTag.m_128431_().forEach(key -> levels.put(ResourceLocation.m_135820_((String)key), levelTag.m_128451_(key)));
        if (compoundTag.m_128441_("disabled")) {
            compoundTag.m_128437_("disabled", 8).forEach(tag -> disabled.add(ResourceLocation.m_135820_((String)tag.m_7916_())));
        }
    }
}

