/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import io.github.tigercrl.gokiskills.GokiSkills;
import io.github.tigercrl.gokiskills.config.ConfigUtils;
import io.github.tigercrl.gokiskills.config.GokiSkillConfig;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public interface ISkill {
    public ResourceLocation getLocation();

    public ResourceLocation getCategory();

    public boolean isEnabled();

    public int getMaxLevel();

    public int getDefaultLevel();

    public int getMinLevel();

    public int calcCost(int var1);

    public int calcReturn(int var1);

    @Nullable
    public Double calcBonus(int var1);

    @OnlyIn(value=Dist.CLIENT)
    public AbstractWidget getWidget(int var1, int var2);

    @OnlyIn(value=Dist.CLIENT)
    public int[] getWidgetSize();

    public Component getName();

    public Component getDescription(int var1, @Nullable Double var2);

    public Class<? extends GokiSkillConfig> getConfigClass();

    public GokiSkillConfig getDefaultConfig();

    default public <T extends GokiSkillConfig> T getConfig() {
        return (T)ConfigUtils.fromJsonObject(GokiSkills.getConfig().skills.get(this.getLocation().toString()), this.getConfigClass());
    }
}

