/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.client.gui;

public class SkillResource<T> {
    private final T defaultItem;
    private final T hoverItem;
    private final T maxLevelItem;
    private final T operationItem;
    private final T operationHoverItem;

    public SkillResource(T defaultItem, T hoverItem, T maxLevelItem, T operationItem, T operationHoverItem) {
        this.defaultItem = defaultItem;
        this.hoverItem = hoverItem;
        this.maxLevelItem = maxLevelItem;
        this.operationItem = operationItem;
        this.operationHoverItem = operationHoverItem;
    }

    public T getDefaultItem() {
        return this.defaultItem;
    }

    public T getHoverItem() {
        return this.hoverItem;
    }

    public T getMaxLevelItem() {
        return this.maxLevelItem;
    }

    public T getOperationItem() {
        return this.operationItem;
    }

    public T getOperationHoverItem() {
        return this.operationHoverItem;
    }

    public T getItem(boolean hover, boolean maxLevel, boolean operation) {
        if (operation) {
            return hover ? this.operationHoverItem : this.operationItem;
        }
        if (maxLevel) {
            return this.maxLevelItem;
        }
        return hover ? this.hoverItem : this.defaultItem;
    }

    public static class Builder<T> {
        private T defaultItem;
        private T hoverItem;
        private T maxLevelItem;
        private T operationItem;
        private T operationHoverItem;
        private int textureWidth;
        private int textureHeight;

        public Builder<T> setDefaultItem(T defaultItem) {
            this.defaultItem = defaultItem;
            return this;
        }

        public Builder<T> setHoverItem(T hoverItem) {
            this.hoverItem = hoverItem;
            return this;
        }

        public Builder<T> setMaxLevelItem(T maxLevelItem) {
            this.maxLevelItem = maxLevelItem;
            return this;
        }

        public Builder<T> setOperationItem(T operationItem) {
            this.operationItem = operationItem;
            return this;
        }

        public Builder<T> setOperationHoverItem(T operationHoverItem) {
            this.operationHoverItem = operationHoverItem;
            return this;
        }

        public Builder<T> setTextureSize(int textureWidth, int textureHeight) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            return this;
        }

        public Builder<T> setTextureSize(int textureSize) {
            this.textureWidth = textureSize;
            this.textureHeight = textureSize;
            return this;
        }

        public Builder<T> setTextureWidth(int textureWidth) {
            this.textureWidth = textureWidth;
            return this;
        }

        public Builder<T> setTextureHeight(int textureHeight) {
            this.textureHeight = textureHeight;
            return this;
        }

        public SkillResource<T> build() {
            if (this.defaultItem == null) {
                throw new IllegalStateException("Default image must be set");
            }
            if (this.textureWidth <= 0) {
                throw new IllegalStateException("Texture width must be set and greater than 0");
            }
            if (this.textureHeight <= 0) {
                throw new IllegalStateException("Texture height must be set and greater than 0");
            }
            return new SkillResource<T>(this.defaultItem, this.hoverItem == null ? this.defaultItem : this.hoverItem, this.maxLevelItem == null ? this.defaultItem : this.maxLevelItem, this.operationItem == null ? this.defaultItem : this.operationItem, this.operationHoverItem == null ? (this.operationItem == null ? this.defaultItem : this.operationItem) : this.operationHoverItem);
        }
    }
}

