/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.tigercrl.gokiskills.client.GokiSkillsClient;
import io.github.tigercrl.gokiskills.client.gui.screens.SkillsMenuScreen;
import io.github.tigercrl.gokiskills.network.C2SDowngradeMessage;
import io.github.tigercrl.gokiskills.network.C2SFastDowngradeMessage;
import io.github.tigercrl.gokiskills.network.C2SFastUpgradeMessage;
import io.github.tigercrl.gokiskills.network.C2SToggleMessage;
import io.github.tigercrl.gokiskills.network.C2SUpgradeMessage;
import io.github.tigercrl.gokiskills.skill.Skill;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

@Environment(value=EnvType.CLIENT)
public class SkillButton
extends Button {
    public static final int DEFAULT_WIDTH = 24;
    public static final int DEFAULT_HEIGHT = 24;
    public static final int DEFAULT_ICON_PADDING = 4;
    private static final Component LOADING = Component.translatable((String)"gui.gokiskills.loading.skill");
    private static final Component DISABLED = Component.translatable((String)"gui.gokiskills.disabled").withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY));
    private static final Component NO_DOWNGRADE = Component.translatable((String)"gui.gokiskills.downgrade.no").withStyle(Style.EMPTY.withColor(ChatFormatting.RED));
    private static final Component DOWNGRADE = Component.translatable((String)"gui.gokiskills.downgrade").withStyle(Style.EMPTY.withColor(-13658630));
    private static final Component NO_UPGRADE = Component.translatable((String)"gui.gokiskills.upgrade.no").withStyle(Style.EMPTY.withColor(ChatFormatting.RED));
    private static final Component UPGRADE = Component.translatable((String)"gui.gokiskills.upgrade").withStyle(Style.EMPTY.withColor(-11535825));
    public static boolean hasControlDown = false;
    public static boolean hasShiftDown = false;
    public static boolean hasAltDown = false;
    private final Skill skill;
    private boolean waitForUpdate = false;
    public int level = 0;
    public boolean enabled = true;

    public SkillButton(int x, int y, Skill skill) {
        super(x, y, 24, 24, CommonComponents.EMPTY, b -> {}, DEFAULT_NARRATION);
        this.skill = skill;
        this.updateLevel();
    }

    public void onPress() {
        if (hasAltDown) {
            this.waitForUpdate = true;
            new C2SToggleMessage(this.skill.getLocation()).sendToServer();
        } else {
            int[] result = SkillInfo.calcOperation(this.skill, this.level, SkillsMenuScreen.playerXp, !hasControlDown, hasShiftDown);
            if (!this.waitForUpdate && result[0] != 0) {
                if (hasControlDown && hasShiftDown) {
                    if (this.level > this.skill.getMinLevel()) {
                        this.waitForUpdate = true;
                        new C2SFastDowngradeMessage(this.skill.getLocation()).sendToServer();
                    }
                } else if (hasControlDown) {
                    if (this.level > this.skill.getMinLevel()) {
                        this.waitForUpdate = true;
                        new C2SDowngradeMessage(this.skill.getLocation()).sendToServer();
                    }
                } else if (hasShiftDown) {
                    if (this.level < this.skill.getMaxLevel()) {
                        this.waitForUpdate = true;
                        new C2SFastUpgradeMessage(this.skill.getLocation()).sendToServer();
                    }
                } else if (this.level < this.skill.getMaxLevel()) {
                    this.waitForUpdate = true;
                    new C2SUpgradeMessage(this.skill.getLocation()).sendToServer();
                }
            }
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        boolean isHovered = this.isHovered();
        boolean maxLevel = GokiSkillsClient.playerInfo.getLevel(this.skill) == this.skill.getMaxLevel();
        boolean operation = hasControlDown || hasShiftDown || hasAltDown;
        RenderSystem.enableBlend();
        guiGraphics.blit((ResourceLocation)this.skill.getBackground().getItem(isHovered, maxLevel, operation), this.getX(), this.getY(), 0, 0.0f, 0.0f, this.width, this.height, this.skill.getBackground().getTextureWidth(), this.skill.getBackground().getTextureHeight());
        guiGraphics.blit((ResourceLocation)this.skill.getOverlay().getItem(isHovered, maxLevel, operation), this.getX(), this.getY(), 0, 0.0f, 0.0f, this.width, this.height, this.skill.getOverlay().getTextureWidth(), this.skill.getOverlay().getTextureHeight());
        guiGraphics.blit((ResourceLocation)this.skill.getIcon().getItem(isHovered, maxLevel, operation), this.getX() + 4, this.getY() + 4, 0.0f, 0.0f, this.width - 8, this.height - 8, this.skill.getIcon().getTextureWidth(), this.skill.getIcon().getTextureHeight());
        guiGraphics.blit((ResourceLocation)this.skill.getFrame().getItem(isHovered, maxLevel, operation), this.getX() - 1, this.getY() - 1, 0, 0.0f, 0.0f, this.width + 2, this.height + 2, this.skill.getFrame().getTextureWidth(), this.skill.getFrame().getTextureHeight());
        RenderSystem.disableBlend();
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, (Component)(this.waitForUpdate ? LOADING : (this.enabled ? Component.literal((String)(this.level + "/" + this.skill.getMaxLevel())) : DISABLED)), this.getX() + this.width / 2, this.getY() + this.height + 3, !this.waitForUpdate && maxLevel ? -9145 : 0xFFFFFF);
    }

    public void renderTooltip(GuiGraphics guiGraphics, int i, int j) {
        boolean maxLevel;
        boolean bl = maxLevel = GokiSkillsClient.playerInfo.getLevel(this.skill) == this.skill.getMaxLevel();
        if (this.isHovered) {
            Component click = null;
            MutableComponent cost = null;
            int[] result = SkillInfo.calcOperation(this.skill, this.level, SkillsMenuScreen.playerXp, !hasControlDown, hasShiftDown);
            if (hasAltDown) {
                click = this.enabled ? Component.translatable((String)"gui.gokiskills.toggle.off").withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW)) : Component.translatable((String)"gui.gokiskills.toggle.on").withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW));
            } else if (hasControlDown) {
                if (result[0] == 0) {
                    click = NO_DOWNGRADE;
                } else if (hasShiftDown) {
                    click = Component.translatable((String)"gui.gokiskills.downgrade.fast", (Object[])new Object[]{-result[0]}).withStyle(Style.EMPTY.withColor(-13658630));
                    cost = Component.translatable((String)"gui.gokiskills.return", (Object[])new Object[]{result[1]}).withStyle(Style.EMPTY.withColor(-8405510));
                } else {
                    click = DOWNGRADE;
                    cost = Component.translatable((String)"gui.gokiskills.return", (Object[])new Object[]{result[1]}).withStyle(Style.EMPTY.withColor(-8405510));
                }
            } else if (!maxLevel) {
                if (result[0] == 0) {
                    click = NO_UPGRADE;
                } else if (hasShiftDown) {
                    click = Component.translatable((String)"gui.gokiskills.upgrade.fast", (Object[])new Object[]{result[0]}).withStyle(Style.EMPTY.withColor(-11535825));
                    cost = Component.translatable((String)"gui.gokiskills.cost", (Object[])new Object[]{-result[1]}).withStyle(Style.EMPTY.withColor(-6291570));
                } else {
                    click = UPGRADE;
                    cost = Component.translatable((String)"gui.gokiskills.cost", (Object[])new Object[]{-result[1]}).withStyle(Style.EMPTY.withColor(-6291570));
                }
            }
            ArrayList<Object> tooltipComponents = new ArrayList<Object>();
            tooltipComponents.add(this.skill.getName().copy().append((Component)Component.literal((String)" ")).append((Component)(maxLevel ? Component.translatable((String)"gui.gokiskills.max_level").withStyle(Style.EMPTY.withColor(this.enabled ? -9145 : 0xAAAAAA)) : Component.literal((String)("Lv" + this.level)))).withStyle(Style.EMPTY.withColor(this.enabled ? (maxLevel ? -13312 : 0xFFFFFF) : 0xAAAAAA)));
            tooltipComponents.add(this.skill.getDescription(this.level, this.skill.calcBonus(this.level)).copy().withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
            if (click != null) {
                tooltipComponents.add(click);
            }
            if (cost != null) {
                tooltipComponents.add(cost);
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, tooltipComponents, Optional.empty(), i, j);
        }
    }

    public void updateLevel() {
        this.level = GokiSkillsClient.playerInfo.getLevel(this.skill);
        this.enabled = GokiSkillsClient.playerInfo.isEnabled(this.skill.getLocation());
        this.waitForUpdate = false;
    }
}

