/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.config;

import io.github.tigercrl.gokiskills.config.ConfigException;
import io.github.tigercrl.gokiskills.config.GokiConfig;

public class GokiSkillConfig
implements GokiConfig {
    public boolean enabled = true;
    public double costMultiplier = 1.0;
    public double downgradeReturnFactor = 0.8;
    public double bonusMultiplier = 1.0;
    public int minLevel = 0;
    public int defaultLevel = 0;
    public int maxLevel = 25;

    @Override
    public void validatePostLoad() throws ConfigException {
        if (this.costMultiplier < 0.0) {
            throw new ConfigException("Cost multiplier cannot be negative");
        }
        if (this.downgradeReturnFactor < 0.0) {
            throw new ConfigException("Downgrade return factor cannot be negative");
        }
        if (this.bonusMultiplier < 0.0) {
            throw new ConfigException("Bonus multiplier cannot be negative");
        }
        if (this.minLevel < this.defaultLevel) {
            throw new ConfigException("Min level cannot be less than default level");
        }
        if (this.minLevel < 0) {
            throw new ConfigException("Min level cannot be negative");
        }
        if (this.maxLevel < this.minLevel) {
            throw new ConfigException("Max level cannot be less than min level");
        }
    }
}

