/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.mixin;

import io.github.tigercrl.gokiskills.misc.GokiPlayer;
import io.github.tigercrl.gokiskills.misc.GokiServerPlayer;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.ServerSkillInfo;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
implements GokiServerPlayer {
    @Shadow
    public ServerGamePacketListenerImpl field_13987;
    @Unique
    @NotNull
    private SkillInfo gokiskills$info = new SkillInfo();

    @Shadow
    public abstract void method_7255(int var1);

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void saveSkillsInfo(CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.put("GokiSkills", (Tag)this.gokiskills$info.toNbt());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readSkillsInfo(CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.contains("GokiSkills")) {
            this.gokiskills$info = ServerSkillInfo.fromNbt(compoundTag.getCompound("GokiSkills"), (ServerPlayer)this);
        }
    }

    @Override
    @Unique
    @NotNull
    public SkillInfo getSkillInfo() {
        return this.gokiskills$info;
    }

    @Override
    @Unique
    public void updateSkill(ISkill skill, boolean upgrade, boolean fast) {
        ServerPlayer p = (ServerPlayer)this;
        int level = this.gokiskills$info.getLevel(skill);
        int[] result = SkillInfo.calcOperation(skill, level, ((GokiPlayer)p).getPlayerTotalXp(), upgrade, fast);
        this.gokiskills$info.setLevel(skill, level + result[0]);
        this.method_7255(result[1]);
        this.field_13987.send((Packet)new ClientboundSetExperiencePacket(p.experienceProgress, p.totalExperience, p.experienceLevel));
    }
}

