/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import io.github.tigercrl.gokiskills.GokiSkills;
import io.github.tigercrl.gokiskills.misc.GokiEvents;
import io.github.tigercrl.gokiskills.misc.GokiUtils;
import io.github.tigercrl.gokiskills.network.S2CSyncSkillInfoMessage;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import io.github.tigercrl.gokiskills.skill.SkillManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class ServerSkillInfo
extends SkillInfo {
    public final ServerPlayer player;

    public ServerSkillInfo(ServerPlayer player) {
        this(new HashMap<ResourceLocation, Integer>(), new HashSet<ResourceLocation>(), player);
    }

    protected ServerSkillInfo(Map<ResourceLocation, Integer> levels, Set<ResourceLocation> disabled, ServerPlayer player) {
        super(levels, disabled);
        this.player = player;
    }

    @Override
    public void setLevel(ISkill skill, int level) {
        this.levels.put(skill.getLocation(), level);
        ((GokiEvents.SkillInfoUpdate)GokiEvents.UPDATE.invoker()).update(skill, this.player, level, this.getLevel(skill), this);
        this.sync();
    }

    @Override
    public void toggle(ISkill skill) {
        if (this.isEnabled(skill.getLocation())) {
            this.disabled.add(skill.getLocation());
        } else {
            this.disabled.remove(skill.getLocation());
        }
        ((GokiEvents.SkillInfoToggle)GokiEvents.TOGGLE.invoker()).toggle(skill, this.player, this.isEnabled(skill), this);
        this.sync();
    }

    @Override
    public void onDeath() {
        if (GokiSkills.config.lostLevelOnDeath.enabled) {
            this.levels.forEach((key, value) -> {
                boolean lost;
                boolean bl = lost = Math.random() < GokiSkills.config.lostLevelOnDeath.chance;
                if (lost) {
                    ISkill s = (ISkill)SkillManager.SKILL.get(key);
                    int lostLevel = Math.min(GokiUtils.randomInt(GokiSkills.config.lostLevelOnDeath.minLevel, GokiSkills.config.lostLevelOnDeath.maxLevel + 1), value - s.getMinLevel());
                    if (lostLevel > 0) {
                        this.levels.put(key, value - lostLevel);
                        this.sync();
                    }
                }
            });
        }
    }

    @Override
    public void sync() {
        new S2CSyncSkillInfoMessage(this).sendTo(this.player);
    }

    @Override
    @Nullable
    public CompoundTag toNbt() {
        CompoundTag compoundTag = new CompoundTag();
        CompoundTag levelTag = new CompoundTag();
        this.levels.forEach((key, value) -> levelTag.putInt(key.toString(), value.intValue()));
        compoundTag.put("levels", (Tag)levelTag);
        ListTag disabledTag = new ListTag();
        this.disabled.forEach(key -> disabledTag.add((Object)StringTag.valueOf((String)key.toString())));
        compoundTag.put("disabled", (Tag)disabledTag);
        compoundTag.putInt("schema", 1);
        return compoundTag;
    }

    public static SkillInfo fromNbt(CompoundTag compoundTag, ServerPlayer player) {
        HashMap<ResourceLocation, Integer> levels = new HashMap<ResourceLocation, Integer>();
        HashSet<ResourceLocation> disabled = new HashSet<ResourceLocation>();
        SkillManager.SKILL.entrySet().forEach(entry -> levels.put(((ResourceKey)entry.getKey()).location(), ((ISkill)entry.getValue()).getDefaultLevel()));
        if (compoundTag.contains("schema")) {
            switch (compoundTag.getInt("schema")) {
                case 1: {
                    ServerSkillInfo.readVer1(compoundTag, levels, disabled);
                }
            }
        } else if (compoundTag.contains("levels")) {
            ServerSkillInfo.readVer1(compoundTag, levels, disabled);
        } else {
            ServerSkillInfo.readVer0(compoundTag, levels);
        }
        return new ServerSkillInfo(levels, disabled, player);
    }

    private static void readVer0(CompoundTag compoundTag, Map<ResourceLocation, Integer> levels) {
        compoundTag.getAllKeys().forEach(key -> levels.put(ResourceLocation.tryParse((String)key), compoundTag.getInt(key)));
    }

    private static void readVer1(CompoundTag compoundTag, Map<ResourceLocation, Integer> levels, Set<ResourceLocation> disabled) {
        CompoundTag levelTag = compoundTag.getCompound("levels");
        levelTag.getAllKeys().forEach(key -> levels.put(ResourceLocation.tryParse((String)key), levelTag.getInt(key)));
        if (compoundTag.contains("disabled")) {
            compoundTag.getList("disabled", 8).forEach(tag -> disabled.add(ResourceLocation.tryParse((String)tag.getAsString())));
        }
    }
}

