/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import io.github.tigercrl.gokiskills.client.GokiSkillsClient;
import io.github.tigercrl.gokiskills.misc.GokiServerPlayer;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class SkillInfo {
    public final int SCHEMA_VERSION = 1;
    protected final Map<ResourceLocation, Integer> levels;
    protected final Set<ResourceLocation> disabled;

    public SkillInfo() {
        this(new HashMap<ResourceLocation, Integer>(), new HashSet<ResourceLocation>());
    }

    protected SkillInfo(Map<ResourceLocation, Integer> levels, Set<ResourceLocation> disabled) {
        this.levels = levels;
        this.disabled = disabled;
    }

    public int getLevel(ISkill skill) {
        this.levels.putIfAbsent(skill.getLocation(), skill.getDefaultLevel());
        return this.levels.get(skill.getLocation());
    }

    public int getLevel(ResourceLocation location) {
        return this.getLevel((ISkill)SkillManager.SKILL.get(location));
    }

    @Nullable
    public Double getBonus(ISkill skill) {
        return skill.calcBonus(this.isEnabled(skill) ? this.getLevel(skill) : skill.getDefaultLevel());
    }

    @Nullable
    public Double getBonus(ResourceLocation location) {
        return this.getBonus((ISkill)SkillManager.SKILL.get(location));
    }

    public void setLevel(ISkill skill, int level) {
    }

    public void setLevel(ResourceLocation location, int level) {
        this.setLevel((ISkill)SkillManager.SKILL.get(location), level);
    }

    public boolean isEnabled(ISkill skill) {
        return skill.isEnabled() && !this.disabled.contains(skill.getLocation());
    }

    public boolean isEnabled(ResourceLocation location) {
        return this.isEnabled((ISkill)SkillManager.SKILL.get(location));
    }

    public void toggle(ISkill skill) {
    }

    public void toggle(ResourceLocation location) {
        this.toggle((ISkill)SkillManager.SKILL.get(location));
    }

    public void onDeath() {
    }

    public void sync() {
    }

    @Nullable
    public CompoundTag toNbt() {
        return null;
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.writeMap(this.levels, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeVarInt);
        buf.writeCollection(this.disabled, FriendlyByteBuf::writeResourceLocation);
    }

    public static SkillInfo fromBuf(FriendlyByteBuf buf) {
        return new SkillInfo(new HashMap<ResourceLocation, Integer>(buf.readMap(FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readVarInt)), (Set)buf.readCollection(HashSet::new, FriendlyByteBuf::readResourceLocation));
    }

    public static int[] calcOperation(ISkill skill, int level, int xp, boolean upgrade, boolean fast) {
        int addXp = 0;
        int addLevel = 0;
        if (upgrade) {
            if (fast) {
                int thisCost;
                while (level + addLevel < skill.getMaxLevel() && -addXp + (thisCost = skill.calcCost(level + addLevel)) <= xp) {
                    ++addLevel;
                    addXp -= thisCost;
                }
                return new int[]{addLevel, addXp};
            }
            addXp = skill.calcCost(level);
            if (addXp > xp || level + 1 > skill.getMaxLevel()) {
                return new int[]{0, 0};
            }
            return new int[]{1, -addXp};
        }
        if (fast) {
            while (level + addLevel > skill.getMinLevel()) {
                addXp += skill.calcReturn(level + addLevel);
                --addLevel;
            }
            return new int[]{addLevel, addXp};
        }
        if (level - 1 < skill.getMinLevel()) {
            return new int[]{0, 0};
        }
        addXp = skill.calcReturn(level);
        return new int[]{-1, addXp};
    }

    public static SkillInfo getInfo(Player player) {
        if (player.level().isClientSide()) {
            return GokiSkillsClient.playerInfo == null ? new SkillInfo() : GokiSkillsClient.playerInfo;
        }
        return ((GokiServerPlayer)player).getSkillInfo();
    }
}

