/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import io.github.tigercrl.gokiskills.config.ConfigUtils;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.Skills;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class SkillManager {
    public static final ResourceKey<Registry<ISkill>> REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)new ResourceLocation("gokiskills", "skills"));
    public static Registry<ISkill> SKILL;
    private static final Logger LOGGER;

    public static void init(WritableRegistry<WritableRegistry<?>> writableRegistry, Map<ResourceLocation, Supplier<?>> LOADERS) {
        Lifecycle lifecycle = Lifecycle.stable();
        SKILL = new MappedRegistry(REGISTRY, lifecycle, false);
        LOADERS.put(REGISTRY.location(), () -> Skills.bootstrap(SKILL));
        writableRegistry.register(REGISTRY, (Object)((WritableRegistry)SKILL), lifecycle);
    }

    @Environment(value=EnvType.CLIENT)
    public static List<List<ISkill>> getSortedSkills() {
        Set skills = SKILL.entrySet();
        HashMap skillCategories = new HashMap();
        skills.forEach(entry -> {
            ISkill skill = (ISkill)entry.getValue();
            if (skillCategories.containsKey(skill.getCategory())) {
                ((Map)skillCategories.get(skill.getCategory())).put(((ResourceKey)entry.getKey()).location(), skill);
            } else {
                HashMap<ResourceLocation, ISkill> category = new HashMap<ResourceLocation, ISkill>();
                category.put(((ResourceKey)entry.getKey()).location(), skill);
                skillCategories.put(skill.getCategory(), category);
            }
        });
        return skillCategories.entrySet().stream().sorted((e1, e2) -> SkillManager.compareResourceLocation((ResourceLocation)e1.getKey(), (ResourceLocation)e2.getKey())).map(Map.Entry::getValue).map(map -> map.entrySet().stream().sorted((e1, e2) -> SkillManager.compareResourceLocation((ResourceLocation)e1.getKey(), (ResourceLocation)e2.getKey())).map(Map.Entry::getValue).filter(ISkill::isEnabled).toList()).filter(list -> !list.isEmpty()).toList();
    }

    @Environment(value=EnvType.CLIENT)
    public static int compareResourceLocation(ResourceLocation location1, ResourceLocation location2) {
        boolean isGoki1 = location1.getNamespace().equals("gokiskills");
        boolean isGoki2 = location2.getNamespace().equals("gokiskills");
        if (isGoki1 && !isGoki2) {
            return -1;
        }
        if (!isGoki1 && isGoki2) {
            return 1;
        }
        int compare = location1.compareTo(location2);
        if (compare != 0) {
            return compare;
        }
        return location1.getPath().compareTo(location2.getPath());
    }

    public static Map<String, JsonObject> getDefaultConfigs() {
        HashMap configs = new HashMap();
        SKILL.entrySet().forEach(entry -> {
            try {
                configs.put(((ResourceKey)entry.getKey()).location().toString(), ConfigUtils.toJsonObject(((ISkill)entry.getValue()).getDefaultConfig()));
            }
            catch (Exception e) {
                LOGGER.warn("Error creating config for skill {}", (Object)((ResourceKey)entry.getKey()).location(), (Object)e);
            }
        });
        return Map.copyOf(configs);
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

