/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.client.gui.screens;

import io.github.tigercrl.gokiskills.client.GokiSkillsClient;
import io.github.tigercrl.gokiskills.client.gui.components.SkillButton;
import io.github.tigercrl.gokiskills.misc.GokiUtils;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillManager;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

@Environment(value=EnvType.CLIENT)
public class SkillsMenuScreen
extends Screen {
    private static final Component LOADING = Component.translatable((String)"gui.gokiskills.loading.menu");
    private static final Component LEFT_BOTTOM_1 = System.getProperty("os.name").toLowerCase().contains("mac") ? Component.translatable((String)"gui.gokiskills.help.1.macos") : Component.translatable((String)"gui.gokiskills.help.1");
    private static final Component LEFT_BOTTOM_2 = Component.translatable((String)"gui.gokiskills.help.2");
    public static final int HORIZONTAL_SPACING = 11;
    public static final int VERTICAL_SPACING = 20;
    public static int playerXp = 0;
    private final Screen parent;
    private long lastUpdated = -1L;
    private boolean loaded = false;

    public SkillsMenuScreen(Screen parent) {
        super((Component)Component.translatable((String)"gui.gokiskills.title"));
        this.parent = parent;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    protected void init() {
        if (this.loaded) {
            this.onLoaded();
        }
    }

    protected void onLoaded() {
        List<List<ISkill>> skills = SkillManager.getSortedSkills();
        List<Integer> lineHeight = skills.stream().map(row -> row.stream().mapToInt(s -> s.getWidgetSize()[1]).max().orElse(24)).toList();
        int height = (skills.size() - 1) * 20 + lineHeight.stream().reduce(0, Integer::sum);
        int yStart = (this.height - height) / 2;
        for (int i = 0; i < skills.size(); ++i) {
            List<ISkill> row2 = skills.get(i);
            int y = yStart + i * 20 + lineHeight.stream().limit(i).reduce(0, Integer::sum);
            List<Integer> widths = row2.stream().map(s -> s.getWidgetSize()[0]).toList();
            int width = (row2.size() - 1) * 11 + widths.stream().reduce(0, Integer::sum);
            int xStart = (this.width - width) / 2;
            for (int j = 0; j < row2.size(); ++j) {
                int x = xStart + j * 11 + widths.stream().limit(j).reduce(0, Integer::sum);
                ISkill skill = row2.get(j);
                this.addRenderableWidget((GuiEventListener)skill.getWidget(x, y));
            }
        }
    }

    public void tick() {
        super.tick();
        if (!this.loaded && GokiSkillsClient.serverConfig != null && GokiSkillsClient.playerInfo != null) {
            this.loaded = true;
            this.onLoaded();
        }
        playerXp = GokiUtils.getPlayerTotalXp((Player)this.minecraft.player);
        if (GokiSkillsClient.lastPlayerInfoUpdated > this.lastUpdated) {
            this.lastUpdated = GokiSkillsClient.lastPlayerInfoUpdated;
            for (int i = 0; i < this.children().size(); ++i) {
                Object e = this.children().get(i);
                if (!(e instanceof SkillButton)) continue;
                SkillButton button = (SkillButton)((Object)e);
                button.updateLevel();
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBackground(guiGraphics);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
        SkillButton.hasControlDown = SkillsMenuScreen.hasControlDown();
        SkillButton.hasShiftDown = SkillsMenuScreen.hasShiftDown();
        SkillButton.hasAltDown = SkillsMenuScreen.hasAltDown();
        if (!this.loaded) {
            String s = LoadingDotsText.get((long)Util.getMillis());
            guiGraphics.drawCenteredString(this.font, s, this.width / 2, this.height / 2 - 6, 0x808080);
            guiGraphics.drawCenteredString(this.font, LOADING, this.width / 2, this.height / 2 + 6, 0xFFFFFF);
        } else {
            super.render(guiGraphics, i, j, f);
            MutableComponent RIGHT_BOTTOM = Component.translatable((String)"gui.gokiskills.xp", (Object[])new Object[]{GokiUtils.getPlayerTotalXp((Player)this.minecraft.player)});
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, LEFT_BOTTOM_1, 4, this.height - 9 * 2 - 4, 0xFFFFFF);
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, LEFT_BOTTOM_2, 4, this.height - 9 - 4, 0xFFFFFF);
            int n = this.width - this.font.width((FormattedText)RIGHT_BOTTOM) - 4;
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, (Component)RIGHT_BOTTOM, n, this.height - 9 - 4, 0xFFFFFF);
            for (int k = 0; k < this.children().size(); ++k) {
                Object e = this.children().get(k);
                if (!(e instanceof SkillButton)) continue;
                SkillButton button = (SkillButton)((Object)e);
                button.renderTooltip(guiGraphics, i, j);
            }
        }
    }

    public boolean keyPressed(int i, int j, int k) {
        return super.keyPressed(i, j, k);
    }
}

