/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.network;

import dev.architectury.networking.simple.MessageType;
import dev.architectury.networking.simple.SimpleNetworkManager;
import io.github.tigercrl.gokiskills.misc.GokiUtils;
import io.github.tigercrl.gokiskills.network.C2SDowngradeMessage;
import io.github.tigercrl.gokiskills.network.C2SFastDowngradeMessage;
import io.github.tigercrl.gokiskills.network.C2SFastUpgradeMessage;
import io.github.tigercrl.gokiskills.network.C2SRequestConfigMessage;
import io.github.tigercrl.gokiskills.network.C2SRequestSkillInfoMessage;
import io.github.tigercrl.gokiskills.network.C2SToggleMessage;
import io.github.tigercrl.gokiskills.network.C2SUpgradeMessage;
import io.github.tigercrl.gokiskills.network.S2CSyncConfigMessage;
import io.github.tigercrl.gokiskills.network.S2CSyncSkillInfoMessage;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.ServerSkillInfo;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import io.github.tigercrl.gokiskills.skill.SkillManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public interface GokiNetwork {
    public static final SimpleNetworkManager NET = SimpleNetworkManager.create((String)"gokiskills");
    public static final MessageType REQUEST_CONFIG = NET.registerC2S("request_config", buf -> new C2SRequestConfigMessage());
    public static final MessageType SYNC_CONFIG = NET.registerS2C("sync_config", S2CSyncConfigMessage::new);
    public static final MessageType REQUEST_SKILL_INFO = NET.registerC2S("request_skill_info", buf -> new C2SRequestSkillInfoMessage());
    public static final MessageType SYNC_SKILL_INFO = NET.registerS2C("sync_skill_info", S2CSyncSkillInfoMessage::new);
    public static final MessageType SKILL_UPGRADE = NET.registerC2S("skill_upgrade", C2SUpgradeMessage::new);
    public static final MessageType SKILL_FAST_UPGRADE = NET.registerC2S("skill_fast_upgrade", C2SFastUpgradeMessage::new);
    public static final MessageType SKILL_DOWNGRADE = NET.registerC2S("skill_downgrade", C2SDowngradeMessage::new);
    public static final MessageType SKILL_FAST_DOWNGRADE = NET.registerC2S("skill_fast_downgrade", C2SFastDowngradeMessage::new);
    public static final MessageType SKILL_TOGGLE = NET.registerC2S("skill_toggle", C2SToggleMessage::new);

    public static void handleLevelOperation(ServerPlayer p, ResourceLocation location, boolean upgrade, boolean fast) {
        ISkill skill = (ISkill)SkillManager.SKILL.get(location);
        SkillInfo skillInfo = SkillManager.getInfo((Player)p);
        int level = skillInfo.getLevel(skill);
        int[] result = SkillManager.calcOperation(skill, level, GokiUtils.getPlayerTotalXp((Player)p), upgrade, fast);
        skillInfo.setLevel(location, level + result[0]);
        p.giveExperiencePoints(result[1]);
        ((ServerSkillInfo)SkillManager.getInfo((Player)p)).sync();
        p.connection.send((Packet)new ClientboundSetExperiencePacket(p.experienceProgress, p.totalExperience, p.experienceLevel));
    }
}

