/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import com.mojang.logging.LogUtils;
import io.github.tigercrl.gokiskills.GokiSkills;
import io.github.tigercrl.gokiskills.config.ConfigUtils;
import io.github.tigercrl.gokiskills.config.GokiSkillConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public interface ISkill {
    public static final Logger LOGGER = LogUtils.getLogger();

    public ResourceLocation getResourceLocation();

    public ResourceLocation getCategory();

    public boolean isEnabled();

    public int getMaxLevel();

    public int getDefaultLevel();

    public int getMinLevel();

    public int calcCost(int var1);

    public int calcReturn(int var1);

    @Nullable
    public Double calcBonus(int var1);

    @Environment(value=EnvType.CLIENT)
    public AbstractWidget getWidget(int var1, int var2);

    @Environment(value=EnvType.CLIENT)
    public int[] getWidgetSize();

    public Component getName();

    public Component getDescription(int var1, @Nullable Double var2);

    public Class<? extends GokiSkillConfig> getConfigClass();

    public GokiSkillConfig getDefaultConfig();

    public ResourceLocation getLocation();

    default public <T extends GokiSkillConfig> T getConfig() {
        return (T)ConfigUtils.fromJsonObject(GokiSkills.getConfig().skills.get(this.getResourceLocation().toString()), this.getConfigClass());
    }
}

