/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import io.github.tigercrl.gokiskills.skill.SkillManager;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ServerSkillInfo
extends SkillInfo {
    public static final Event<SkillInfoUpdate> UPDATE = EventFactory.createLoop(SkillInfoUpdate.class);
    public static final Event<SkillInfoToggle> TOGGLE = EventFactory.createLoop(SkillInfoToggle.class);
    private final ServerPlayer player;

    public ServerSkillInfo(ServerPlayer player) {
        this.player = player;
    }

    protected ServerSkillInfo(Map<ResourceLocation, Integer> levels, Set<ResourceLocation> disabled, ServerPlayer player) {
        super(levels, disabled);
        this.player = player;
    }

    @Override
    public void setLevel(ISkill skill, int level) {
        int oldLevel = this.getLevel(skill);
        super.setLevel(skill, level);
        ((SkillInfoUpdate)UPDATE.invoker()).update(skill, this.player, level, oldLevel, this);
    }

    @Override
    public void setLevel(ResourceLocation location, int level) {
        ISkill skill = (ISkill)SkillManager.SKILL.get(location);
        int oldLevel = this.getLevel(skill);
        super.setLevel(location, level);
        ((SkillInfoUpdate)UPDATE.invoker()).update(skill, this.player, level, oldLevel, this);
    }

    @Override
    public void toggle(ResourceLocation location) {
        ISkill skill = (ISkill)SkillManager.SKILL.get(location);
        super.toggle(location);
        ((SkillInfoToggle)TOGGLE.invoker()).toggle(skill, this.player, this.isEnabled(skill), this);
    }

    public void sync() {
        super.sync(this.player);
    }

    @Override
    public void sync(ServerPlayer player) {
        this.sync();
    }

    public void onDeath() {
        super.onDeath(this.player);
    }

    @Override
    public void onDeath(ServerPlayer player) {
        this.onDeath();
    }

    public static interface SkillInfoUpdate {
        public void update(ISkill var1, ServerPlayer var2, int var3, int var4, ServerSkillInfo var5);
    }

    public static interface SkillInfoToggle {
        public void toggle(ISkill var1, ServerPlayer var2, boolean var3, ServerSkillInfo var4);
    }
}

