/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import io.github.tigercrl.gokiskills.GokiSkills;
import io.github.tigercrl.gokiskills.misc.GokiUtils;
import io.github.tigercrl.gokiskills.network.S2CSyncSkillInfoMessage;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.ServerSkillInfo;
import io.github.tigercrl.gokiskills.skill.SkillManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class SkillInfo {
    private final int SCHEMA_VERSION = 1;
    private final Map<ResourceLocation, Integer> levels;
    private final Set<ResourceLocation> disabled;

    public SkillInfo() {
        this(new HashMap<ResourceLocation, Integer>(), new HashSet<ResourceLocation>());
    }

    protected SkillInfo(Map<ResourceLocation, Integer> levels, Set<ResourceLocation> disabled) {
        this.levels = levels;
        this.disabled = disabled;
    }

    public int getLevel(ISkill skill) {
        return this.getLevel(skill.getResourceLocation(), skill.getDefaultLevel());
    }

    public int getLevel(ResourceLocation location, int defaultLevel) {
        this.levels.putIfAbsent(location, defaultLevel);
        return this.levels.get(location);
    }

    @Nullable
    public Double getBonus(ISkill skill) {
        return skill.calcBonus(this.isEnabled(skill) ? this.getLevel(skill) : skill.getDefaultLevel());
    }

    public void setLevel(ISkill skill, int level) {
        this.levels.put(skill.getResourceLocation(), level);
    }

    public void setLevel(ResourceLocation location, int level) {
        this.setLevel((ISkill)SkillManager.SKILL.get(location), level);
    }

    public boolean isEnabled(ISkill skill) {
        return skill.isEnabled() && !this.disabled.contains(skill.getResourceLocation());
    }

    public boolean isEnabled(ResourceLocation location) {
        return this.isEnabled((ISkill)SkillManager.SKILL.get(location));
    }

    public void toggle(ResourceLocation location) {
        if (this.isEnabled(location)) {
            this.disabled.add(location);
        } else {
            this.disabled.remove(location);
        }
    }

    public void onDeath(ServerPlayer player) {
        if (GokiSkills.config.lostLevelOnDeath.enabled) {
            this.levels.forEach((key, value) -> {
                boolean lost;
                boolean bl = lost = Math.random() < GokiSkills.config.lostLevelOnDeath.chance;
                if (lost) {
                    ISkill s = (ISkill)SkillManager.SKILL.get(key);
                    int lostLevel = Math.min(GokiUtils.randomInt(GokiSkills.config.lostLevelOnDeath.minLevel, GokiSkills.config.lostLevelOnDeath.maxLevel + 1), value - s.getMinLevel());
                    if (lostLevel > 0) {
                        this.levels.put((ResourceLocation)key, value - lostLevel);
                        this.sync(player);
                    }
                }
            });
        }
    }

    public ServerSkillInfo toServerSkillInfo(ServerPlayer player) {
        return new ServerSkillInfo(this.levels, this.disabled, player);
    }

    public void sync(ServerPlayer player) {
        new S2CSyncSkillInfoMessage(this).sendTo(player);
    }

    public CompoundTag toNbt() {
        CompoundTag compoundTag = new CompoundTag();
        CompoundTag levelTag = new CompoundTag();
        this.levels.forEach((key, value) -> levelTag.putInt(key.toString(), value.intValue()));
        compoundTag.put("levels", (Tag)levelTag);
        ListTag disabledTag = new ListTag();
        this.disabled.forEach(key -> disabledTag.add((Object)StringTag.valueOf((String)key.toString())));
        compoundTag.put("disabled", (Tag)disabledTag);
        compoundTag.putInt("schema", 1);
        return compoundTag;
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.writeMap(this.levels, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeVarInt);
        buf.writeCollection(this.disabled, FriendlyByteBuf::writeResourceLocation);
    }

    public static SkillInfo fromBuf(FriendlyByteBuf buf) {
        return new SkillInfo(new HashMap<ResourceLocation, Integer>(buf.readMap(FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readVarInt)), (Set)buf.readCollection(HashSet::new, FriendlyByteBuf::readResourceLocation));
    }

    public static SkillInfo fromNbt(CompoundTag compoundTag) {
        HashMap<ResourceLocation, Integer> levels = new HashMap<ResourceLocation, Integer>();
        HashSet<ResourceLocation> disabled = new HashSet<ResourceLocation>();
        SkillManager.SKILL.entrySet().forEach(entry -> levels.put(((ResourceKey)entry.getKey()).location(), ((ISkill)entry.getValue()).getDefaultLevel()));
        if (compoundTag.contains("schema")) {
            switch (compoundTag.getInt("schema")) {
                case 1: {
                    SkillInfo.readVer1(compoundTag, levels, disabled);
                }
            }
        } else if (compoundTag.contains("levels")) {
            SkillInfo.readVer1(compoundTag, levels, disabled);
        } else {
            SkillInfo.readVer0(compoundTag, levels);
        }
        return new SkillInfo(levels, disabled);
    }

    private static void readVer0(CompoundTag compoundTag, Map<ResourceLocation, Integer> levels) {
        compoundTag.getAllKeys().forEach(key -> levels.put(ResourceLocation.tryParse((String)key), compoundTag.getInt(key)));
    }

    private static void readVer1(CompoundTag compoundTag, Map<ResourceLocation, Integer> levels, Set<ResourceLocation> disabled) {
        CompoundTag levelTag = compoundTag.getCompound("levels");
        levelTag.getAllKeys().forEach(key -> levels.put(ResourceLocation.tryParse((String)key), levelTag.getInt(key)));
        if (compoundTag.contains("disabled")) {
            compoundTag.getList("disabled", 8).forEach(tag -> disabled.add(ResourceLocation.tryParse((String)tag.getAsString())));
        }
    }
}

