/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import io.github.tigercrl.gokiskills.client.GokiSkillsClient;
import io.github.tigercrl.gokiskills.config.ConfigUtils;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.ServerSkillInfo;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import io.github.tigercrl.gokiskills.skill.Skills;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public class SkillManager {
    public static final ResourceKey<Registry<ISkill>> REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)new ResourceLocation("gokiskills", "skills"));
    public static Registry<ISkill> SKILL;
    public static final Map<ServerPlayer, ServerSkillInfo> INFOS;
    private static final Logger LOGGER;

    public static void init(WritableRegistry<WritableRegistry<?>> writableRegistry, Map<ResourceLocation, Supplier<?>> LOADERS) {
        Lifecycle lifecycle = Lifecycle.stable();
        SKILL = new MappedRegistry(REGISTRY, lifecycle, false);
        LOADERS.put(REGISTRY.location(), () -> Skills.bootstrap(SKILL));
        writableRegistry.register(REGISTRY, (Object)((WritableRegistry)SKILL), lifecycle);
    }

    @Environment(value=EnvType.CLIENT)
    public static List<List<ISkill>> getSortedSkills() {
        Set skills = SKILL.entrySet();
        HashMap skillCategories = new HashMap();
        skills.forEach(entry -> {
            ISkill skill = (ISkill)entry.getValue();
            if (skillCategories.containsKey(skill.getCategory())) {
                ((Map)skillCategories.get(skill.getCategory())).put(((ResourceKey)entry.getKey()).location(), skill);
            } else {
                HashMap<ResourceLocation, ISkill> category = new HashMap<ResourceLocation, ISkill>();
                category.put(((ResourceKey)entry.getKey()).location(), skill);
                skillCategories.put(skill.getCategory(), category);
            }
        });
        return skillCategories.entrySet().stream().sorted((e1, e2) -> SkillManager.compareResourceLocation((ResourceLocation)e1.getKey(), (ResourceLocation)e2.getKey())).map(Map.Entry::getValue).map(map -> map.entrySet().stream().sorted((e1, e2) -> SkillManager.compareResourceLocation((ResourceLocation)e1.getKey(), (ResourceLocation)e2.getKey())).map(Map.Entry::getValue).filter(ISkill::isEnabled).toList()).filter(list -> !list.isEmpty()).toList();
    }

    @Environment(value=EnvType.CLIENT)
    public static int compareResourceLocation(ResourceLocation location1, ResourceLocation location2) {
        boolean isGoki1 = location1.getNamespace().equals("gokiskills");
        boolean isGoki2 = location2.getNamespace().equals("gokiskills");
        if (isGoki1 && !isGoki2) {
            return -1;
        }
        if (!isGoki1 && isGoki2) {
            return 1;
        }
        int compare = location1.compareTo(location2);
        if (compare != 0) {
            return compare;
        }
        return location1.getPath().compareTo(location2.getPath());
    }

    public static Map<String, JsonObject> getDefaultConfigs() {
        HashMap configs = new HashMap();
        SKILL.entrySet().forEach(entry -> {
            try {
                configs.put(((ResourceKey)entry.getKey()).location().toString(), ConfigUtils.toJsonObject(((ISkill)entry.getValue()).getDefaultConfig()));
            }
            catch (Exception e) {
                LOGGER.warn("Error creating config for skill {}", (Object)((ResourceKey)entry.getKey()).location(), (Object)e);
            }
        });
        return Map.copyOf(configs);
    }

    public static int[] calcOperation(ISkill skill, int level, int xp, boolean upgrade, boolean fast) {
        int addXp = 0;
        int addLevel = 0;
        if (upgrade) {
            if (fast) {
                int thisCost;
                while (level + addLevel < skill.getMaxLevel() && -addXp + (thisCost = skill.calcCost(level + addLevel)) <= xp) {
                    ++addLevel;
                    addXp -= thisCost;
                }
                return new int[]{addLevel, addXp};
            }
            addXp = skill.calcCost(level);
            if (addXp > xp || level + 1 > skill.getMaxLevel()) {
                return new int[]{0, 0};
            }
            return new int[]{1, -addXp};
        }
        if (fast) {
            while (level + addLevel > skill.getMinLevel()) {
                addXp += skill.calcReturn(level + addLevel);
                --addLevel;
            }
            return new int[]{addLevel, addXp};
        }
        if (level - 1 < skill.getMinLevel()) {
            return new int[]{0, 0};
        }
        addXp = skill.calcReturn(level);
        return new int[]{-1, addXp};
    }

    public static SkillInfo getInfo(Player player) {
        SkillInfo info = new SkillInfo();
        if (player instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)player;
            SkillInfo skillInfo = info = INFOS.containsKey(p) ? (SkillInfo)INFOS.get(p) : new ServerSkillInfo(p);
        }
        if (player.level().isClientSide()) {
            info = GokiSkillsClient.playerInfo == null ? new SkillInfo() : GokiSkillsClient.playerInfo;
        }
        return info;
    }

    static {
        INFOS = new HashMap<ServerPlayer, ServerSkillInfo>();
        LOGGER = LogUtils.getLogger();
    }
}

