/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills;

import com.mojang.logging.LogUtils;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import io.github.tigercrl.gokiskills.client.GokiSkillsClient;
import io.github.tigercrl.gokiskills.config.CommonConfig;
import io.github.tigercrl.gokiskills.config.ConfigUtils;
import io.github.tigercrl.gokiskills.misc.GokiPlayer;
import io.github.tigercrl.gokiskills.network.GokiNetwork;
import io.github.tigercrl.gokiskills.skill.SkillHooks;
import io.github.tigercrl.gokiskills.skill.SkillRegistry;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import org.slf4j.Logger;

public final class GokiSkills {
    public static final String MOD_ID = "gokiskills";
    public static CommonConfig config;
    private static final Logger LOGGER;

    public static void init() {
        if (Platform.getEnv() == Dist.CLIENT) {
            GokiSkillsClient.init();
        }
        LifecycleEvent.SETUP.register(() -> {
            config = ConfigUtils.readConfig("gokiskills-common", CommonConfig.class);
            StringBuilder sb = new StringBuilder();
            sb.append("Loaded skills: ");
            SkillRegistry.getSkills().forEach(skill -> sb.append(skill.getLocation().toString()).append(", "));
            LOGGER.info(sb.delete(sb.length() - 2, sb.length()).toString());
        });
        EntityEvent.LIVING_DEATH.register((entity, source) -> {
            if (entity instanceof GokiPlayer) {
                GokiPlayer gp = (GokiPlayer)entity;
                gp.getSkillInfo().onDeath();
            }
            return EventResult.pass();
        });
        SkillHooks.register();
        GokiNetwork.NET.toString();
        LOGGER.info("GokiSkills initialized!");
    }

    public static CommonConfig getConfig() {
        if (Platform.getEnv() == Dist.CLIENT && Minecraft.m_91087_().f_91073_ != null && !Minecraft.m_91087_().f_91073_.f_46443_) {
            return GokiSkillsClient.serverConfig;
        }
        return config;
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

