/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import io.github.tigercrl.gokiskills.client.gui.screens.SkillsMenuScreen;
import io.github.tigercrl.gokiskills.config.CommonConfig;
import io.github.tigercrl.gokiskills.network.C2SRequestConfigMessage;
import io.github.tigercrl.gokiskills.network.C2SRequestSkillInfoMessage;
import io.github.tigercrl.gokiskills.skill.SkillHelper;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public final class GokiSkillsClient {
    public static CommonConfig serverConfig;
    public static long lastPlayerInfoUpdated;
    private static long nextSendTime;
    private static final Logger LOGGER;

    public static void init() {
        KeyMapping openMenuKey = new KeyMapping("key.gokiskills.open", InputConstants.Type.KEYSYM, 89, "key.categories.gokiskills");
        KeyMappingRegistry.register((KeyMapping)openMenuKey);
        ClientRawInputEvent.KEY_PRESSED.register((client, keyCode, scanCode, action, modifiers) -> {
            if (client.f_91073_ != null && client.f_91080_ == null && openMenuKey.m_90832_(keyCode, scanCode)) {
                client.m_91152_((Screen)new SkillsMenuScreen(null));
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
        ClientTickEvent.CLIENT_POST.register(client -> {
            long now;
            if (client.f_91073_ != null && (now = Util.m_137550_()) > nextSendTime) {
                if (serverConfig == null) {
                    new C2SRequestConfigMessage().sendToServer();
                }
                if (SkillHelper.getClientInfoOrNull() == null) {
                    new C2SRequestSkillInfoMessage().sendToServer();
                }
                nextSendTime = now + 5000L;
            }
        });
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> {
            serverConfig = null;
            lastPlayerInfoUpdated = 0L;
        });
        LOGGER.info("GokiSkills initialized on client!");
    }

    static {
        lastPlayerInfoUpdated = 0L;
        nextSendTime = 0L;
        LOGGER = LogUtils.getLogger();
    }
}

