/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.tigercrl.gokiskills.client.gui.screens.SkillsMenuScreen;
import io.github.tigercrl.gokiskills.network.C2SDowngradeMessage;
import io.github.tigercrl.gokiskills.network.C2SFastDowngradeMessage;
import io.github.tigercrl.gokiskills.network.C2SFastUpgradeMessage;
import io.github.tigercrl.gokiskills.network.C2SToggleMessage;
import io.github.tigercrl.gokiskills.network.C2SUpgradeMessage;
import io.github.tigercrl.gokiskills.skill.Skill;
import io.github.tigercrl.gokiskills.skill.SkillHelper;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkillButton
extends Button {
    public static final int DEFAULT_WIDTH = 24;
    public static final int DEFAULT_HEIGHT = 24;
    public static final int DEFAULT_ICON_PADDING = 4;
    private static final Component LOADING = Component.m_237115_((String)"gui.gokiskills.loading.skill");
    private static final Component DISABLED = Component.m_237115_((String)"gui.gokiskills.disabled").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));
    private static final Component NO_DOWNGRADE = Component.m_237115_((String)"gui.gokiskills.downgrade.no").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
    private static final Component DOWNGRADE = Component.m_237115_((String)"gui.gokiskills.downgrade").m_130948_(Style.f_131099_.m_178520_(-13658630));
    private static final Component NO_UPGRADE = Component.m_237115_((String)"gui.gokiskills.upgrade.no").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
    private static final Component UPGRADE = Component.m_237115_((String)"gui.gokiskills.upgrade").m_130948_(Style.f_131099_.m_178520_(-11535825));
    public static boolean hasControlDown = false;
    public static boolean hasShiftDown = false;
    public static boolean hasAltDown = false;
    private final Skill skill;
    private boolean waitForUpdate = false;
    public int level = 0;
    public boolean enabled = true;

    public SkillButton(int x, int y, Skill skill) {
        super(x, y, 24, 24, CommonComponents.f_237098_, b -> {}, f_252438_);
        this.skill = skill;
        this.updateLevel();
    }

    public void m_5691_() {
        if (hasAltDown) {
            this.waitForUpdate = true;
            new C2SToggleMessage(this.skill.getLocation()).sendToServer();
        } else {
            int[] result = SkillHelper.calcOperation(this.skill, this.level, SkillsMenuScreen.playerXp, !hasControlDown, hasShiftDown);
            if (!this.waitForUpdate && result[0] != 0) {
                if (hasControlDown && hasShiftDown) {
                    if (this.level > this.skill.getMinLevel()) {
                        this.waitForUpdate = true;
                        new C2SFastDowngradeMessage(this.skill.getLocation()).sendToServer();
                    }
                } else if (hasControlDown) {
                    if (this.level > this.skill.getMinLevel()) {
                        this.waitForUpdate = true;
                        new C2SDowngradeMessage(this.skill.getLocation()).sendToServer();
                    }
                } else if (hasShiftDown) {
                    if (this.level < this.skill.getMaxLevel()) {
                        this.waitForUpdate = true;
                        new C2SFastUpgradeMessage(this.skill.getLocation()).sendToServer();
                    }
                } else if (this.level < this.skill.getMaxLevel()) {
                    this.waitForUpdate = true;
                    new C2SUpgradeMessage(this.skill.getLocation()).sendToServer();
                }
            }
        }
    }

    public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        boolean isHovered = this.m_274382_();
        boolean maxLevel = SkillHelper.getClientInfo().getLevel(this.skill) == this.skill.getMaxLevel();
        boolean operation = hasControlDown || hasShiftDown || hasAltDown;
        RenderSystem.enableBlend();
        guiGraphics.m_280398_((ResourceLocation)this.skill.getBackground().getItem(isHovered, maxLevel, operation), this.m_252754_(), this.m_252907_(), 0, 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.skill.getBackground().getTextureWidth(), this.skill.getBackground().getTextureHeight());
        guiGraphics.m_280398_((ResourceLocation)this.skill.getOverlay().getItem(isHovered, maxLevel, operation), this.m_252754_(), this.m_252907_(), 0, 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.skill.getOverlay().getTextureWidth(), this.skill.getOverlay().getTextureHeight());
        guiGraphics.m_280163_((ResourceLocation)this.skill.getIcon().getItem(isHovered, maxLevel, operation), this.m_252754_() + 4, this.m_252907_() + 4, 0.0f, 0.0f, this.f_93618_ - 8, this.f_93619_ - 8, this.skill.getIcon().getTextureWidth(), this.skill.getIcon().getTextureHeight());
        guiGraphics.m_280398_((ResourceLocation)this.skill.getFrame().getItem(isHovered, maxLevel, operation), this.m_252754_() - 1, this.m_252907_() - 1, 0, 0.0f, 0.0f, this.f_93618_ + 2, this.f_93619_ + 2, this.skill.getFrame().getTextureWidth(), this.skill.getFrame().getTextureHeight());
        RenderSystem.disableBlend();
        guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)(this.waitForUpdate ? LOADING : (this.enabled ? Component.m_237113_((String)(this.level + "/" + this.skill.getMaxLevel())) : DISABLED)), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + this.f_93619_ + 3, !this.waitForUpdate && maxLevel ? -9145 : 0xFFFFFF);
    }

    public void renderTooltip(GuiGraphics guiGraphics, int i, int j) {
        boolean maxLevel;
        boolean bl = maxLevel = SkillHelper.getClientInfo().getLevel(this.skill) == this.skill.getMaxLevel();
        if (this.f_93622_) {
            Component click = null;
            MutableComponent cost = null;
            int[] result = SkillHelper.calcOperation(this.skill, this.level, SkillsMenuScreen.playerXp, !hasControlDown, hasShiftDown);
            if (hasAltDown) {
                click = this.enabled ? Component.m_237115_((String)"gui.gokiskills.toggle.off").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)) : Component.m_237115_((String)"gui.gokiskills.toggle.on").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
            } else if (hasControlDown) {
                if (result[0] == 0) {
                    click = NO_DOWNGRADE;
                } else if (hasShiftDown) {
                    click = Component.m_237110_((String)"gui.gokiskills.downgrade.fast", (Object[])new Object[]{-result[0]}).m_130948_(Style.f_131099_.m_178520_(-13658630));
                    cost = Component.m_237110_((String)"gui.gokiskills.return", (Object[])new Object[]{result[1]}).m_130948_(Style.f_131099_.m_178520_(-8405510));
                } else {
                    click = DOWNGRADE;
                    cost = Component.m_237110_((String)"gui.gokiskills.return", (Object[])new Object[]{result[1]}).m_130948_(Style.f_131099_.m_178520_(-8405510));
                }
            } else if (!maxLevel) {
                if (result[0] == 0) {
                    click = NO_UPGRADE;
                } else if (hasShiftDown) {
                    click = Component.m_237110_((String)"gui.gokiskills.upgrade.fast", (Object[])new Object[]{result[0]}).m_130948_(Style.f_131099_.m_178520_(-11535825));
                    cost = Component.m_237110_((String)"gui.gokiskills.cost", (Object[])new Object[]{-result[1]}).m_130948_(Style.f_131099_.m_178520_(-6291570));
                } else {
                    click = UPGRADE;
                    cost = Component.m_237110_((String)"gui.gokiskills.cost", (Object[])new Object[]{-result[1]}).m_130948_(Style.f_131099_.m_178520_(-6291570));
                }
            }
            ArrayList<Object> tooltipComponents = new ArrayList<Object>();
            tooltipComponents.add(this.skill.getName().m_6881_().m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)(maxLevel ? Component.m_237115_((String)"gui.gokiskills.max_level").m_130948_(Style.f_131099_.m_178520_(this.enabled ? -9145 : 0xAAAAAA)) : Component.m_237113_((String)("Lv" + this.level)))).m_130948_(Style.f_131099_.m_178520_(this.enabled ? (maxLevel ? -13312 : 0xFFFFFF) : 0xAAAAAA)));
            tooltipComponents.add(this.skill.getDescription(this.level, this.skill.calcBonus(this.level)).m_6881_().m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
            if (click != null) {
                tooltipComponents.add(click);
            }
            if (cost != null) {
                tooltipComponents.add(cost);
            }
            guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltipComponents, Optional.empty(), i, j);
        }
    }

    public void updateLevel() {
        this.level = SkillHelper.getClientInfo().getLevel(this.skill);
        this.enabled = SkillHelper.getClientInfo().isEnabled(this.skill.getLocation());
        this.waitForUpdate = false;
    }
}

