/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.client.gui.screens;

import io.github.tigercrl.gokiskills.client.GokiSkillsClient;
import io.github.tigercrl.gokiskills.client.gui.components.SkillButton;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillHelper;
import io.github.tigercrl.gokiskills.skill.SkillRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkillsMenuScreen
extends Screen {
    private static final Component LOADING = Component.m_237115_((String)"gui.gokiskills.loading.menu");
    private static final Component LEFT_BOTTOM = System.getProperty("os.name").toLowerCase().contains("mac") ? Component.m_237115_((String)"gui.gokiskills.help.macos") : Component.m_237115_((String)"gui.gokiskills.help");
    public static final int HORIZONTAL_SPACING = 10;
    public static final int VERTICAL_SPACING = 17;
    public static int playerXp = 0;
    private final Screen parent;
    private long lastUpdated = -1L;
    private boolean loaded = false;

    public SkillsMenuScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"gui.gokiskills.title"));
        this.parent = parent;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    protected void m_7856_() {
        if (this.loaded) {
            this.onLoaded();
        }
    }

    protected void onLoaded() {
        List<List<ISkill>> skills = SkillRegistry.getSortedSkills();
        List<Integer> lineHeight = skills.stream().map(row -> row.stream().mapToInt(s -> s.getWidgetSize()[1]).max().orElse(24)).toList();
        int height = (skills.size() - 1) * 17 + lineHeight.stream().reduce(0, Integer::sum);
        int yStart = (this.f_96544_ - height) / 2 - 5;
        for (int i = 0; i < skills.size(); ++i) {
            List<ISkill> row2 = skills.get(i);
            int y = yStart + i * 17 + lineHeight.stream().limit(i).reduce(0, Integer::sum);
            List<Integer> widths = row2.stream().map(s -> s.getWidgetSize()[0]).toList();
            int width = (row2.size() - 1) * 10 + widths.stream().reduce(0, Integer::sum);
            int xStart = (this.f_96543_ - width) / 2;
            for (int j = 0; j < row2.size(); ++j) {
                int x = xStart + j * 10 + widths.stream().limit(j).reduce(0, Integer::sum);
                ISkill skill = row2.get(j);
                this.m_142416_((GuiEventListener)skill.getWidget(x, y));
            }
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (!this.loaded && GokiSkillsClient.serverConfig != null && SkillHelper.getClientInfoOrNull() != null) {
            this.loaded = true;
            this.onLoaded();
        }
        playerXp = SkillHelper.getClientTotalXp();
        if (GokiSkillsClient.lastPlayerInfoUpdated > this.lastUpdated) {
            this.lastUpdated = GokiSkillsClient.lastPlayerInfoUpdated;
            for (int i = 0; i < this.m_6702_().size(); ++i) {
                Object e = this.m_6702_().get(i);
                if (!(e instanceof SkillButton)) continue;
                SkillButton button = (SkillButton)((Object)e);
                button.updateLevel();
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        SkillButton.hasControlDown = SkillsMenuScreen.m_96637_();
        SkillButton.hasShiftDown = SkillsMenuScreen.m_96638_();
        SkillButton.hasAltDown = SkillsMenuScreen.m_96639_();
        if (!this.loaded) {
            String s = LoadingDotsText.m_232744_((long)Util.m_137550_());
            guiGraphics.m_280137_(this.f_96547_, s, this.f_96543_ / 2, this.f_96544_ / 2 - 6, 0x808080);
            guiGraphics.m_280653_(this.f_96547_, LOADING, this.f_96543_ / 2, this.f_96544_ / 2 + 6, 0xFFFFFF);
        } else {
            super.m_88315_(guiGraphics, i, j, f);
            Component[] leftBottoms = (Component[])Arrays.stream(LEFT_BOTTOM.getString().split("\n")).map(Component::m_237113_).toArray(Component[]::new);
            for (int k = 0; k < leftBottoms.length; ++k) {
                Component component = leftBottoms[k];
                Objects.requireNonNull(this.f_96547_);
                guiGraphics.m_280430_(this.f_96547_, component, 5, this.f_96544_ - 9 * (leftBottoms.length - k) - 4, 0xFFFFFF);
            }
            MutableComponent RIGHT_BOTTOM = Component.m_237110_((String)"gui.gokiskills.xp", (Object[])new Object[]{SkillHelper.getClientTotalXp()});
            int n = this.f_96543_ - this.f_96547_.m_92852_((FormattedText)RIGHT_BOTTOM) - 4;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280430_(this.f_96547_, (Component)RIGHT_BOTTOM, n, this.f_96544_ - 9 - 4, 0xFFFFFF);
            for (int k = 0; k < this.m_6702_().size(); ++k) {
                Object e = this.m_6702_().get(k);
                if (!(e instanceof SkillButton)) continue;
                SkillButton button = (SkillButton)((Object)e);
                button.renderTooltip(guiGraphics, i, j);
            }
        }
    }

    public boolean m_7933_(int i, int j, int k) {
        return super.m_7933_(i, j, k);
    }
}

