/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import dev.architectury.event.events.common.PlayerEvent;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillEvents;
import io.github.tigercrl.gokiskills.skill.SkillHelper;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import io.github.tigercrl.gokiskills.skill.Skills;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class SkillHooks {
    public static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("ac28fc4a-8ee1-4998-87b6-cdfe8754b2d6");
    public static final UUID KNOCKBACK_RESISTANCE_MODIFIER_UUID = UUID.fromString("44352496-cb58-4ce3-a261-facd73f08190");
    public static final UUID NINJA_SPEED_MODIFIER_UUID = UUID.fromString("a1e60be0-0511-45a3-aa37-5b217b23c9ad");

    public static void register() {
        PlayerEvent.PLAYER_JOIN.register(SkillHooks::updateAttributes);
        PlayerEvent.PLAYER_RESPAWN.register((player, conqueredEnd) -> {
            SkillHooks.updateAttributes(player);
            player.m_21153_(player.m_21233_());
        });
        SkillEvents.UPDATE.register((skill, player, newLevel, oldLevel, info) -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                SkillHooks.updateAttribute(sp, info, skill);
            }
        });
        SkillEvents.TOGGLE.register((skill, player, newState, info) -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                SkillHooks.updateAttribute(sp, info, skill);
            }
        });
    }

    public static void updateAttributes(ServerPlayer player) {
        SkillInfo info = SkillHelper.getInfo((Player)player);
        SkillHooks.updateAttribute(player, info, Skills.KNOCKBACK_RESISTANCE);
        SkillHooks.updateAttribute(player, info, Skills.HEALTH);
    }

    public static void updateAttribute(ServerPlayer player, SkillInfo info, ISkill skill) {
        if (skill == Skills.KNOCKBACK_RESISTANCE) {
            SkillHooks.updateAttribute(player, info, Skills.KNOCKBACK_RESISTANCE, Attributes.f_22278_, KNOCKBACK_RESISTANCE_MODIFIER_UUID, "GokiSkills knockback resistance", AttributeModifier.Operation.ADDITION);
        } else if (skill == Skills.HEALTH) {
            SkillHooks.updateAttribute(player, info, Skills.HEALTH, Attributes.f_22276_, HEALTH_MODIFIER_UUID, "GokiSkills health", AttributeModifier.Operation.ADDITION);
        }
    }

    public static void updateAttribute(ServerPlayer player, SkillInfo info, ISkill skill, Attribute attribute, UUID uuid, String name, AttributeModifier.Operation operation) {
        SkillHooks.updateAttribute(player, info, skill, attribute, uuid, name, operation, true);
    }

    public static void updateAttribute(ServerPlayer player, SkillInfo info, ISkill skill, Attribute attribute, UUID uuid, String name, AttributeModifier.Operation operation, boolean condition) {
        double bonus = info.getBonus(skill);
        AttributeInstance instance = player.m_21051_(attribute);
        AttributeModifier oldModifier = instance.m_22111_(uuid);
        if (condition && info.isEnabled(skill) && bonus > 0.0) {
            if (oldModifier == null || oldModifier.m_22218_() != bonus) {
                instance.m_22120_(uuid);
                instance.m_22118_(new AttributeModifier(uuid, name, bonus, operation));
            }
        } else if (oldModifier != null) {
            instance.m_22130_(oldModifier);
        }
    }
}

